/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.editor.model.AbstractBaseEditorElement;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.AbstractBaseProcessorTemplate;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.RequieredForDatasenseEnricher;

public class ConnectionProviderItemProcessor
extends AbstractBaseProcessorTemplate<ConnectionProviderModel, Nested> {
    @Override
    protected List<ConnectionProviderModel> getModelRootElements(ExtensionModel extensionModel) {
        return extensionModel.getConnectionProviders().stream().sorted((x, y) -> x.getName().compareTo(y.getName())).collect(Collectors.toList());
    }

    @Override
    protected List<ConnectionProviderModel> getModelConfigurationElements(ConfigurationModel config) {
        return config.getConnectionProviders();
    }

    @Override
    protected void postProcessModelRootElement(ConnectionProviderModel model, Nested editorElement, Context context, DslElementSyntax dslElementSyntax) {
        DslSyntaxResolver resolver = context.getResolver();
        for (ConfigurationModel config : context.getModel().getConfigurationModels()) {
            DslElementSyntax configDsl = resolver.resolve(config);
            context.linkProviderWithConfig(configDsl.getElementName(), editorElement);
        }
        RequieredForDatasenseEnricher.markRequiredFields((AbstractBaseEditorElement)editorElement);
    }

    @Override
    protected void postProcessModelConfigurationElement(ConnectionProviderModel model, ConfigurationModel config, Nested editorElement, Context context, DslElementSyntax dslElementSyntax) {
        DslSyntaxResolver resolver = context.getResolver();
        DslElementSyntax configDsl = resolver.resolve(config);
        context.linkProviderWithConfig(configDsl.getElementName(), editorElement);
        RequieredForDatasenseEnricher.markRequiredFields((AbstractBaseEditorElement)editorElement);
    }

    @Override
    protected String getNameFrom(ConnectionProviderModel componentModel) {
        return componentModel.getName();
    }

    @Override
    protected DslElementSyntax resolveDslElementSyntax(DslSyntaxResolver resolver, ConnectionProviderModel componentModel) {
        return resolver.resolve(componentModel);
    }

    @Override
    protected void configureEditorCommonValues(Nested editorElement, ConnectionProviderModel componentModel, Context context, DslElementSyntax dslElementSyntax) {
        EditorGeneratorUtils.setCommonValues(context.getModuleId(), (AbstractBaseEditorElement)editorElement, componentModel, context, dslElementSyntax);
    }

    @Override
    protected void configureSpecificEditorProperties(ConnectionProviderModel componentModel, Nested editorElement) {
        EditorGeneratorUtils.configureExternalLibraries(componentModel.getExternalLibraryModels(), () -> EditorGeneratorUtils.getOrCreateTab(editorElement.getChildElements(), "General"));
    }

    @Override
    protected List<ParameterGroupModel> getParameterGroupModelsFrom(ConnectionProviderModel componentModel) {
        return componentModel.getParameterGroupModels();
    }

    @Override
    protected StereotypeModel getStereotypeFrom(ConnectionProviderModel componentModel) {
        return componentModel.getStereotype();
    }

    @Override
    protected Nested createEditorModel(ConnectionProviderModel componentModel) {
        return new Nested();
    }

    @Override
    protected void doProcess(Nested editorElement, AttributeCategory attributeCategory, ConnectionProviderModel componentModel, Context context, DslElementSyntax dslElementSyntax) {
        editorElement.setExtendsElement(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), "abstract-connection-provider"));
        editorElement.setIsAbstract(Boolean.valueOf(false));
        editorElement.setDescription(componentModel.getDescription());
    }

    @Override
    protected void addToContext(Nested editorElement, ConnectionProviderModel componentModel, Context context) {
        EditorGeneratorUtils.removeGeneralLabelsFromGroupsInsideTabs((AbstractBaseEditorElement)editorElement);
        context.addConnectionProvider(editorElement);
    }
}

