/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.function.Consumer;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.editor.model.AbstractBaseEditorElement;
import org.mule.tooling.editor.model.contribution.CloudConnector;
import org.mule.tooling.editor.model.contribution.CloudConnectorMessageSource;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;

public class ConfigurationsPostProcessor
implements Consumer<Context> {
    @Override
    public void accept(Context context) {
        if (this.hasOperations(context)) {
            this.addConnectorAbstractBaseOperation(context);
        }
        if (this.hasSources(context)) {
            this.addConnectorAbstractSourceBaseOperation(context);
        }
    }

    private boolean hasSources(Context context) {
        boolean hasSources;
        ExtensionModel model = context.getModel();
        boolean bl = hasSources = !model.getSourceModels().isEmpty();
        if (!hasSources) {
            for (ConfigurationModel config : model.getConfigurationModels()) {
                if (config.getSourceModels().isEmpty()) continue;
                hasSources = true;
                break;
            }
        }
        return hasSources;
    }

    private boolean hasOperations(Context context) {
        boolean hasOperations;
        ExtensionModel model = context.getModel();
        boolean bl = hasOperations = !model.getOperationModels().isEmpty();
        if (!hasOperations) {
            for (ConfigurationModel config : model.getConfigurationModels()) {
                if (config.getOperationModels().isEmpty()) continue;
                hasOperations = true;
                break;
            }
        }
        return hasOperations;
    }

    private void addConnectorAbstractBaseOperation(Context context) {
        CloudConnector cloudConnector = new CloudConnector();
        cloudConnector.setCaption(EditorGeneratorUtils.getAbstractOperationParentValue(context.getNamespace()));
        cloudConnector.setLocalId(EditorGeneratorUtils.getAbstractOperationParentValue(context.getNamespace()));
        EditorGeneratorUtils.setIcons(context.getModuleId(), (AbstractBaseEditorElement)cloudConnector, context.getNamespace());
        cloudConnector.setIsAbstract(Boolean.valueOf(true));
        cloudConnector.setVersions("[4.0,10.0]");
        context.getNamespace().getComponents().add(cloudConnector);
    }

    private void addConnectorAbstractSourceBaseOperation(Context context) {
        CloudConnectorMessageSource cloudConnector = new CloudConnectorMessageSource();
        cloudConnector.setCaption(EditorGeneratorUtils.getAbstractSourceParentValue(context.getNamespace()));
        cloudConnector.setLocalId(EditorGeneratorUtils.getAbstractSourceParentValue(context.getNamespace()));
        EditorGeneratorUtils.setIcons(context.getModuleId(), (AbstractBaseEditorElement)cloudConnector, context.getNamespace());
        cloudConnector.setIsAbstract(Boolean.valueOf(true));
        cloudConnector.setVersions("[4.0,10.0]");
        context.getNamespace().getComponents().add(cloudConnector);
    }
}

