/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;
import org.mule.tooling.editor.model.AbstractBaseEditorElement;
import org.mule.tooling.editor.model.ConnectivityTesting;
import org.mule.tooling.editor.model.MetaDataBehaviour;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.contribution.global.AbstractGlobalElement;
import org.mule.tooling.editor.model.contribution.global.GlobalCloudConnector;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.editor.model.element.Group;
import org.mule.tooling.editor.model.element.MultiWay;
import org.mule.tooling.editor.model.element.NameEditor;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.AbstractBaseProcessorTemplate;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.EditorLocalIdComparator;
import org.mule.tooling.internal.extension.api.RequieredForDatasenseEnricher;
import org.mule.tooling.utils.collection.ListView;

public class ConfigurationItemProcessor
extends AbstractBaseProcessorTemplate<ConfigurationModel, GlobalCloudConnector> {
    private void addConnectionProviderGroup(AttributeCategory attributeCategory, Context context, ConfigurationModel configurationModel, int xmlOrder) {
        if (context.getConectionProviders().isEmpty()) {
            return;
        }
        DslElementSyntax configDsl = context.getResolver().resolve(configurationModel);
        List<Nested> conectionProviders = context.getProviders(configDsl.getElementName());
        if (!conectionProviders.isEmpty()) {
            MultiWay multiWay = new MultiWay();
            multiWay.setAllowSubTypes(false);
            multiWay.setRequired(Boolean.valueOf(!this.hasImplicitConnectionProvider(context, configurationModel, conectionProviders)));
            multiWay.setModes("INLINE");
            multiWay.setName("connectionProvider");
            multiWay.setHideOnEmpty(Boolean.valueOf(true));
            multiWay.setRequiredForDataSense(Boolean.valueOf(true));
            multiWay.setXmlOrder(Integer.valueOf(xmlOrder));
            Optional<String> values = conectionProviders.stream().sorted(new EditorLocalIdComparator()).map(x -> EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), x.getLocalId())).reduce((x, y) -> x + "," + y);
            multiWay.setAllowedElements(values.get());
            multiWay.setCaption("Connection");
            Set<ConnectionProviderModel> allConfigProviders = this.getAllAssociatedProviders(context, configurationModel);
            List allowedTypes = allConfigProviders.stream().map(ConnectionProviderModel::getStereotype).map(this::toStereotype).collect(Collectors.toList());
            multiWay.setAllowedStereotypes(allowedTypes);
            attributeCategory.getChildElements().add(multiWay);
        }
    }

    private boolean hasImplicitConnectionProvider(Context context, ConfigurationModel configurationModel, List<Nested> conectionProviders) {
        int totalConnectionProviders = this.getAllAssociatedProviders(context, configurationModel).size();
        if (totalConnectionProviders >= 2) {
            return false;
        }
        return this.hasOnlyOneConnectionProviderWithAllParametersOptional(context, configurationModel, totalConnectionProviders);
    }

    private boolean hasOnlyOneConnectionProviderWithAllParametersOptional(Context context, ConfigurationModel configurationModel, int totalConnectionProviders) {
        boolean allProviderParametersAreOptional = true;
        if (totalConnectionProviders == 1) {
            ConnectionProviderModel provider = this.getProvider(configurationModel, context);
            allProviderParametersAreOptional = provider.getParameterGroupModels().stream().flatMap(y -> y.getParameterModels().stream()).noneMatch(ParameterModel::isRequired);
        }
        return allProviderParametersAreOptional;
    }

    private Set<ConnectionProviderModel> getAllAssociatedProviders(Context context, ConfigurationModel configurationModel) {
        Stream commonConnectionProviders = context.getModel().getConnectionProviders().stream();
        Stream configurationConnectionProviders = configurationModel.getConnectionProviders().stream();
        return Stream.concat(commonConnectionProviders, configurationConnectionProviders).collect(Collectors.toSet());
    }

    private boolean isConfigurationOptional(ConfigurationModel configurationModel, Context context) {
        int totalConnectionProviders = this.getAllAssociatedProviders(context, configurationModel).size();
        if (totalConnectionProviders >= 2) {
            return false;
        }
        boolean allConfigParametersAreOptional = configurationModel.getParameterGroupModels().stream().flatMap(x -> x.getParameterModels().stream()).noneMatch(ParameterModel::isRequired);
        boolean allProviderParametersAreOptional = this.hasOnlyOneConnectionProviderWithAllParametersOptional(context, configurationModel, totalConnectionProviders);
        return allConfigParametersAreOptional && allProviderParametersAreOptional;
    }

    private ConnectionProviderModel getProvider(ConfigurationModel configurationModel, Context context) {
        return configurationModel.getConnectionProviders().isEmpty() ? (ConnectionProviderModel)context.getModel().getConnectionProviders().get(0) : (ConnectionProviderModel)configurationModel.getConnectionProviders().get(0);
    }

    @Override
    protected String getNameFrom(ConfigurationModel componentModel) {
        return componentModel.getName();
    }

    @Override
    protected List<ConfigurationModel> getModelRootElements(ExtensionModel extensionModel) {
        return extensionModel.getConfigurationModels();
    }

    @Override
    protected DslElementSyntax resolveDslElementSyntax(DslSyntaxResolver resolver, ConfigurationModel componentModel) {
        return resolver.resolve(componentModel);
    }

    @Override
    protected void configureSpecificEditorProperties(ConfigurationModel componentModel, GlobalCloudConnector editorElement) {
    }

    @Override
    protected List<ParameterGroupModel> getParameterGroupModelsFrom(ConfigurationModel componentModel) {
        return componentModel.getParameterGroupModels();
    }

    @Override
    protected void configureEditorCommonValues(GlobalCloudConnector editorElement, ConfigurationModel componentModel, Context context, DslElementSyntax dslElementSyntax) {
        EditorGeneratorUtils.setCommonValues(context.getModuleId(), (AbstractBaseEditorElement)editorElement, componentModel, context, dslElementSyntax);
    }

    @Override
    protected StereotypeModel getStereotypeFrom(ConfigurationModel componentModel) {
        return componentModel.getStereotype();
    }

    @Override
    protected GlobalCloudConnector createEditorModel(ConfigurationModel componentModel) {
        return new GlobalCloudConnector();
    }

    @Override
    protected void doProcess(GlobalCloudConnector globalConfig, AttributeCategory attributeCategory, ConfigurationModel configurationModel, Context context, DslElementSyntax configDsl) {
        boolean atLeastOneProviderSupportsConnectivityTest;
        String caption = EditorGeneratorUtils.getCaption(configurationModel.getName(), configurationModel.getDisplayModel());
        globalConfig.setCaption(StringUtils.capitalize((String)context.getModel().getName()) + " " + caption);
        globalConfig.setIsAbstract(Boolean.valueOf(false));
        globalConfig.setConnectivityTesting(ConnectivityTesting.OFF);
        globalConfig.setMetaData(MetaDataBehaviour.DYNAMIC);
        globalConfig.setSupportsUserDefinedMetaData(Boolean.valueOf(true));
        globalConfig.setUsesMetadataTypes(EditorGeneratorUtils.hasAnyComponentWithMetadataKeyPart(configurationModel));
        NameEditor name = EditorGeneratorUtils.createNameEditorWithDescription("Give a name to this configuration so it can be later referenced by config-ref.");
        attributeCategory.getChildElements().add(name);
        EditorGeneratorUtils.configureExternalLibraries(context.getModel().getExternalLibraryModels(), () -> attributeCategory);
        EditorGeneratorUtils.configureExternalLibraries(configurationModel.getExternalLibraryModels(), () -> attributeCategory);
        this.addConnectionProviderGroup(attributeCategory, context, configurationModel, 1);
        List<ConnectionProviderModel> connectionProviders = this.getAllConnectionProviders(context.getModel(), configurationModel);
        if (!connectionProviders.isEmpty() && (atLeastOneProviderSupportsConnectivityTest = connectionProviders.stream().anyMatch(ConnectionProviderModel::supportsConnectivityTesting))) {
            globalConfig.setConnectivityTesting(ConnectivityTesting.ON);
        }
        Group generalGroup = EditorGeneratorUtils.createGeneralGroup();
        attributeCategory.getChildElements().add(generalGroup);
    }

    private List<ConnectionProviderModel> getAllConnectionProviders(ExtensionModel model, ConfigurationModel configurationModel) {
        return ListView.of((List)model.getConnectionProviders(), (List)configurationModel.getConnectionProviders());
    }

    @Override
    protected void addToContext(GlobalCloudConnector editorElement, ConfigurationModel configurationModel, Context context) {
        context.addConfiguration(configurationModel, (AbstractGlobalElement)editorElement, this.isConfigurationOptional(configurationModel, context));
    }

    @Override
    protected void postProcessModelRootElement(ConfigurationModel operationModel, GlobalCloudConnector editorElement, Context context, DslElementSyntax dslElementSyntax) {
        RequieredForDatasenseEnricher.markRequiredFields((AbstractBaseEditorElement)editorElement);
    }
}

