/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.List;
import java.util.Optional;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.editor.model.MetaDataBehaviour;
import org.mule.tooling.editor.model.contribution.AbstractContributionEditorElement;
import org.mule.tooling.editor.model.contribution.CloudConnector;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.editor.model.element.Group;
import org.mule.tooling.editor.model.reference.GlobalRef;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.AbstractComponentModelProcessorTemplate;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.GlobalRefFactory;

public class CloudConnectorItemProcessor
extends AbstractComponentModelProcessorTemplate<OperationModel, CloudConnector> {
    @Override
    protected DslElementSyntax resolveDslElementSyntax(DslSyntaxResolver resolver, OperationModel componentModel) {
        return resolver.resolve(componentModel);
    }

    @Override
    protected CloudConnector createEditorModel(OperationModel componentModel) {
        return new CloudConnector();
    }

    @Override
    protected void doProcess(CloudConnector cloudConnector, AttributeCategory attributeCategory, OperationModel operationModel, Context context, DslElementSyntax dslElementSyntax) {
        Optional<List<String>> associatedConfigs = context.getAssociatedConfigs(cloudConnector.getLocalId());
        Group basicSettings = new Group();
        basicSettings.setId(context.getNamespace().getPrefix() + "ConnectorGeneric");
        basicSettings.setCaption("Basic Settings");
        if (context.getTotalOperations() > 1 || associatedConfigs.isPresent() && !associatedConfigs.get().isEmpty()) {
            attributeCategory.getChildElements().add(basicSettings);
        }
        if (associatedConfigs.isPresent() && !associatedConfigs.get().isEmpty()) {
            GlobalRef globalRefEditor = GlobalRefFactory.createGlobalRefEditor(context, associatedConfigs.get(), context.hasConnectionProviders());
            operationModel.getAllParameterModels().stream().filter(x -> "config-ref".equals(x.getName())).findFirst().ifPresent(parameter -> globalRefEditor.setRequired(Boolean.valueOf(parameter.isRequired())));
            basicSettings.getChildElements().add(globalRefEditor);
        } else {
            EditorGeneratorUtils.configureExternalLibraries(context.getModel().getExternalLibraryModels(), () -> attributeCategory);
        }
        cloudConnector.setExtendsElement("http://www.mulesoft.org/schema/mule/core/abstractOperatorType");
        cloudConnector.setMetaData(MetaDataBehaviour.STATIC);
    }

    @Override
    protected void addToContext(CloudConnector editorElement, OperationModel componentModel, Context context) {
        context.addOperation((AbstractContributionEditorElement)editorElement);
    }
}

