/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.editor.model.AbstractBaseEditorElement;
import org.mule.tooling.editor.model.contribution.global.GlobalCloudConnector;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.editor.model.element.Group;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.AbstractBaseProcessorTemplate;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;

public class AppConfigItemProcessor
extends AbstractBaseProcessorTemplate<ConstructModel, GlobalCloudConnector> {
    @Override
    protected String getNameFrom(ConstructModel componentModel) {
        return componentModel.getName();
    }

    @Override
    protected DslElementSyntax resolveDslElementSyntax(DslSyntaxResolver resolver, ConstructModel componentModel) {
        return resolver.resolve(componentModel);
    }

    @Override
    protected List<ConstructModel> getModelRootElements(ExtensionModel extensionModel) {
        return EditorGeneratorUtils.getAppConfigConstructs(extensionModel.getConstructModels());
    }

    @Override
    protected void configureEditorCommonValues(GlobalCloudConnector editorElement, ConstructModel componentModel, Context context, DslElementSyntax dslElementSyntax) {
        EditorGeneratorUtils.setCommonValues(context.getModuleId(), (AbstractBaseEditorElement)editorElement, (ComponentModel)componentModel, context, dslElementSyntax);
    }

    @Override
    protected void configureSpecificEditorProperties(ConstructModel componentModel, GlobalCloudConnector editorElement) {
    }

    @Override
    protected List<ParameterGroupModel> getParameterGroupModelsFrom(ConstructModel componentModel) {
        return componentModel.getParameterGroupModels();
    }

    @Override
    protected StereotypeModel getStereotypeFrom(ConstructModel componentModel) {
        return componentModel.getStereotype();
    }

    @Override
    protected GlobalCloudConnector createEditorModel(ConstructModel componentModel) {
        return new GlobalCloudConnector();
    }

    @Override
    protected void doProcess(GlobalCloudConnector globalConfig, AttributeCategory attributeCategory, ConstructModel componentModel, Context context, DslElementSyntax dslElementSyntax) {
        String caption = EditorGeneratorUtils.getCaption(componentModel.getName(), componentModel.getDisplayModel());
        globalConfig.setCaption(StringUtils.capitalize((String)context.getModel().getName()) + " " + caption);
        globalConfig.setIsAbstract(Boolean.valueOf(false));
        Group generalGroup = EditorGeneratorUtils.createGeneralGroup();
        attributeCategory.getChildElements().add(generalGroup);
        EditorGeneratorUtils.configureExternalLibraries(context.getModel().getExternalLibraryModels(), () -> attributeCategory);
    }

    @Override
    protected void addToContext(GlobalCloudConnector editorElement, ConstructModel componentModel, Context context) {
        context.getNamespace().getComponents().add(editorElement);
    }
}

