/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModelVisitor;
import org.mule.tooling.client.api.extension.model.nested.NestedChainModel;
import org.mule.tooling.client.api.extension.model.nested.NestedComponentModel;
import org.mule.tooling.client.api.extension.model.nested.NestedRouteModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.editor.model.AbstractBaseEditorElement;
import org.mule.tooling.editor.model.MetaDataBehaviour;
import org.mule.tooling.editor.model.contribution.AbstractContributionEditorElement;
import org.mule.tooling.editor.model.contribution.GraphicalContainer;
import org.mule.tooling.editor.model.contribution.NestedContainer;
import org.mule.tooling.editor.model.contribution.Route;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.editor.model.element.Group;
import org.mule.tooling.editor.model.element.LabelElement;
import org.mule.tooling.editor.model.element.RouteElement;
import org.mule.tooling.editor.model.reference.GlobalRef;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.AbstractComponentModelProcessorTemplate;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.GlobalRefFactory;
import org.mule.tooling.internal.extension.api.MulePathUtils;
import org.mule.tooling.internal.extension.api.ParameterModelProcessor;
import org.mule.tooling.internal.extension.api.XmlOrderSupplier;
import org.mule.tooling.mule.parameters.ParametersUtils;

public abstract class AbstractNestableItemProcessor<T extends AbstractContributionEditorElement>
extends AbstractComponentModelProcessorTemplate<ComponentModel, T> {
    private static final String NO_CONFIGURATION_REQUIRED_MESSAGE = "No configuration required.";

    @Override
    protected DslElementSyntax resolveDslElementSyntax(DslSyntaxResolver resolver, ComponentModel componentModel) {
        if (componentModel instanceof OperationModel) {
            return resolver.resolve((OperationModel)componentModel);
        }
        if (componentModel instanceof ConstructModel) {
            return resolver.resolve((ConstructModel)componentModel);
        }
        throw new IllegalArgumentException("Don't know how to process [" + componentModel.getClass().getName() + "]. The should be no element of this type when generating.");
    }

    @Override
    protected void doProcess(AbstractContributionEditorElement editorElement, AttributeCategory attributeCategory, ComponentModel componentModel, Context context, DslElementSyntax dslElementSyntax) {
        editorElement.setExtendsElement("http://www.mulesoft.org/schema/mule/core/abstractOperatorType");
        editorElement.setMetaData(MetaDataBehaviour.STATIC);
        Optional<List<String>> associatedConfigs = context.getAssociatedConfigs(editorElement.getLocalId());
        Group basicSettings = new Group();
        basicSettings.setId(context.getNamespace().getPrefix() + "ConnectorGeneric");
        basicSettings.setCaption("Basic Settings");
        if (context.getTotalOperations() > 1 || associatedConfigs.isPresent() && !associatedConfigs.get().isEmpty()) {
            attributeCategory.getChildElements().add(basicSettings);
        }
        if (associatedConfigs.isPresent() && !associatedConfigs.get().isEmpty()) {
            GlobalRef createGlobalRefEditor = GlobalRefFactory.createGlobalRefEditor(context, associatedConfigs.get(), context.hasConnectionProviders());
            componentModel.getAllParameterModels().stream().filter(x -> "config-ref".equals(x.getName())).findFirst().ifPresent(parameter -> createGlobalRefEditor.setRequired(Boolean.valueOf(parameter.isRequired())));
            basicSettings.getChildElements().add(createGlobalRefEditor);
        } else {
            EditorGeneratorUtils.configureExternalLibraries(context.getModel().getExternalLibraryModels(), () -> attributeCategory);
        }
    }

    @Override
    protected void processNestableElements(final AbstractContributionEditorElement editorElement, ComponentModel operationModel, final Context context, final DslElementSyntax dslElementSyntax, final XmlOrderSupplier xmlOrder) {
        NestableElementModelVisitor visitor = new NestableElementModelVisitor(){

            public void visit(NestedComponentModel nestedComponentModel) {
                boolean isErrorHandler = AbstractNestableItemProcessor.this.isErrorHandlerStereotype(nestedComponentModel.getAllowedStereotypes());
                NestedContainer container = isErrorHandler ? new NestedContainer() : new GraphicalContainer();
                container.setRowNumber(Integer.valueOf(1));
                container.setLocalId(nestedComponentModel.getName().toLowerCase().replace(" ", "-"));
                if (isErrorHandler) {
                    container.setAcceptsElements("category:org.mule.tooling.ui.modules.core.exceptions");
                }
                container.setShowsResponse(Boolean.valueOf(false));
                DisplayModel displayModel = nestedComponentModel.getDisplayModel();
                container.setPrompt(displayModel != null ? displayModel.getDisplayName() : EditorGeneratorUtils.getCaption(nestedComponentModel.getName()));
                container.setXmlOrder(Integer.valueOf(xmlOrder.getNextXmlOrder()));
                if (StringUtils.isNotBlank((CharSequence)nestedComponentModel.getDescription())) {
                    container.setDescription(nestedComponentModel.getDescription());
                }
                container.setContributesToPath(Boolean.valueOf(true));
                container.setPathExpression(MulePathUtils.getPathExpressionFor(nestedComponentModel.getAllowedStereotypes()));
                container.getAllowedStereotypes().addAll(nestedComponentModel.getAllowedStereotypes().stream().sorted().map(AbstractNestableItemProcessor.this::toStereotype).collect(Collectors.toList()));
                editorElement.getChildElements().add(container);
            }

            public void visit(NestedChainModel nestedChainModel) {
                boolean isErrorHandler = AbstractNestableItemProcessor.this.isErrorHandlerStereotype(nestedChainModel.getAllowedStereotypes());
                NestedContainer container = isErrorHandler ? new NestedContainer() : new GraphicalContainer();
                container.setLocalId(nestedChainModel.getName().toLowerCase().replace(" ", "-"));
                if (isErrorHandler) {
                    container.setAcceptsElements("category:org.mule.tooling.ui.modules.core.exceptions");
                }
                container.setShowsResponse(Boolean.valueOf(false));
                DisplayModel displayModel = nestedChainModel.getDisplayModel();
                container.setPrompt(displayModel != null ? displayModel.getDisplayName() : EditorGeneratorUtils.getCaption(nestedChainModel.getName()));
                container.setXmlOrder(Integer.valueOf(xmlOrder.getNextXmlOrder()));
                if (StringUtils.isNotBlank((CharSequence)nestedChainModel.getDescription())) {
                    container.setDescription(nestedChainModel.getDescription());
                }
                container.setContributesToPath(Boolean.valueOf(true));
                String pathExpressionFor = MulePathUtils.getPathExpressionFor(nestedChainModel.getAllowedStereotypes());
                container.setPathExpression(pathExpressionFor);
                container.getAllowedStereotypes().addAll(nestedChainModel.getAllowedStereotypes().stream().sorted().map(AbstractNestableItemProcessor.this::toStereotype).collect(Collectors.toList()));
                editorElement.getChildElements().add(container);
            }

            public void visit(NestedRouteModel nestedRouteModel) {
                RouteElement container = new RouteElement();
                if (nestedRouteModel.getMinOccurs() > 0) {
                    container.setRequired(Boolean.valueOf(true));
                }
                container.setMaxOccurrence(nestedRouteModel.getMaxOccurs().orElse(1));
                Route routeModel = AbstractNestableItemProcessor.this.getOrCreateRoute(context, nestedRouteModel, dslElementSyntax);
                container.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), routeModel.getLocalId()));
                container.setLocalId(routeModel.getLocalId() + "-ref");
                DisplayModel displayModel = nestedRouteModel.getDisplayModel();
                container.setCaption(displayModel != null ? displayModel.getDisplayName() : EditorGeneratorUtils.getCaption(nestedRouteModel.getName()));
                if (StringUtils.isNotBlank((CharSequence)nestedRouteModel.getDescription())) {
                    container.setDescription(nestedRouteModel.getDescription());
                }
                container.setXmlOrder(Integer.valueOf(xmlOrder.getNextXmlOrder()));
                container.setContributesToPath(Boolean.valueOf(true));
                nestedRouteModel.getChildComponents();
                container.setPathExpression("route/${childIndex}/processors");
                editorElement.getChildElements().add(container);
            }
        };
        operationModel.getNestedComponents().forEach(nested -> nested.accept(visitor));
    }

    private boolean isErrorHandlerStereotype(Collection<StereotypeModel> models) {
        return models.isEmpty() ? false : models.stream().findFirst().map(MulePathUtils::isErrorHandler).orElse(false);
    }

    @Override
    protected void addToContext(AbstractContributionEditorElement editorElement, ComponentModel componentModel, Context context) {
        context.addOperation(editorElement);
    }

    private Route getOrCreateRoute(Context context, NestedRouteModel nestedRouteModel, DslElementSyntax dslElementSyntax) {
        DslElementSyntax routeDsl = (DslElementSyntax)dslElementSyntax.getChild(nestedRouteModel.getName()).orElseThrow(() -> new IllegalStateException("NestedRouteModel should have an DslElementSyntax"));
        Route route = context.getRoute(routeDsl.getElementName());
        if (route == null) {
            final Route newRoute = new Route();
            newRoute.setLocalId(routeDsl.getElementName());
            EditorGeneratorUtils.setIcons(context.getModuleId(), (AbstractBaseEditorElement)newRoute, context.getNamespace());
            XmlOrderSupplier xmlOrder = new XmlOrderSupplier();
            nestedRouteModel.getParameterGroupModels().forEach(parameterGroup -> ParameterModelProcessor.getInstance().processParameterGroup(dslElementSyntax.getChild(parameterGroup.getName()), newRoute.getLocalId(), ParametersUtils.buildGroupName((ParameterGroupModel)parameterGroup), newRoute.getChildElements(), (ParameterGroupModel)parameterGroup, context, xmlOrder, routeDsl, false));
            if (nestedRouteModel.getParameterGroupModels().isEmpty()) {
                AttributeCategory attributeCategory = EditorGeneratorUtils.createGeneralTab();
                newRoute.getChildElements().add(attributeCategory);
                Group generalGroup = EditorGeneratorUtils.createGeneralGroup();
                LabelElement noConfigurationRequired = new LabelElement();
                noConfigurationRequired.setCaption(NO_CONFIGURATION_REQUIRED_MESSAGE);
                generalGroup.getChildElements().add(noConfigurationRequired);
                attributeCategory.getChildElements().add(generalGroup);
            }
            NestableElementModel nestableElementModel = (NestableElementModel)nestedRouteModel.getChildComponents().get(0);
            nestableElementModel.accept(new NestableElementModelVisitor(){

                public void visit(NestedRouteModel nestedChainModel) {
                }

                public void visit(NestedChainModel nestedChainModel) {
                    newRoute.setAllowedStereotypes(nestedChainModel.getAllowedStereotypes().stream().sorted().map(AbstractNestableItemProcessor.this::toStereotype).collect(Collectors.toList()));
                }

                public void visit(NestedComponentModel nestedComponentModel) {
                }
            });
            context.addRoute(newRoute);
            route = newRoute;
        }
        return route;
    }
}

