/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.editor.model.contribution.AbstractContributionEditorElement;
import org.mule.tooling.editor.model.contribution.ErrorType;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.AbstractBaseProcessorTemplate;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;

public abstract class AbstractComponentModelProcessorTemplate<T extends ComponentModel, U extends AbstractContributionEditorElement>
extends AbstractBaseProcessorTemplate<T, U> {
    private static final String WRONG_SOAP_METADATA_CATEGORY_VALUE = "SoapInvoke";
    private static final String ACTUAL_SOAP_METADATA_CATEGORY_VALUE = "InvokeOperationCategory";

    @Override
    protected Set<ErrorModel> getErrorModels(T componentModel) {
        return componentModel.getErrorModels();
    }

    @Override
    protected String getNameFrom(T componentModel) {
        return componentModel.getName();
    }

    @Override
    protected List<ParameterGroupModel> getParameterGroupModelsFrom(T componentModel) {
        return componentModel.getParameterGroupModels();
    }

    @Override
    protected void configureEditorCommonValues(U editorElement, T componentModel, Context context, DslElementSyntax dslElementSyntax) {
        EditorGeneratorUtils.setCommonValues(context.getModuleId(), editorElement, componentModel, context, dslElementSyntax);
    }

    @Override
    protected StereotypeModel getStereotypeFrom(T componentModel) {
        return componentModel.getStereotype();
    }

    @Override
    protected void configureSpecificEditorProperties(T componentModel, U editorElement) {
        this.configureMetadataCateogryIfRequired(componentModel, editorElement);
        this.configureErrorTypes(componentModel, editorElement);
    }

    private void configureMetadataCateogryIfRequired(T componentModel, U editorElement) {
        this.getMetadataKeyIdModel(componentModel).ifPresent(metadataKeyIdModel -> metadataKeyIdModel.getCategoryName().ifEnabled(category -> {
            if (WRONG_SOAP_METADATA_CATEGORY_VALUE.equals(category)) {
                editorElement.setCategories(ACTUAL_SOAP_METADATA_CATEGORY_VALUE);
            } else {
                editorElement.setCategories(category);
            }
        }));
    }

    private void configureErrorTypes(T componentModel, U editorElement) {
        Set<ErrorModel> errorModels = this.getErrorModels(componentModel);
        if (!errorModels.isEmpty()) {
            editorElement.setErrorTypes(errorModels.stream().filter(x -> (Boolean)x.getHandleable().orElse((Object)true)).sorted((x, y) -> x.getType().compareTo(y.getType())).map(e -> new ErrorType(e.getNamespace(), e.getType())).collect(Collectors.toList()));
        }
    }
}

