/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyIdModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;
import org.mule.tooling.editor.model.AbstractBaseEditorElement;
import org.mule.tooling.editor.model.Alternative;
import org.mule.tooling.editor.model.RequiredSetAlternatives;
import org.mule.tooling.editor.model.contribution.global.AbstractGlobalElement;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.ParameterModelProcessor;
import org.mule.tooling.internal.extension.api.XmlOrderSupplier;
import org.mule.tooling.mule.parameters.ParametersUtils;

public abstract class AbstractBaseProcessorTemplate<T, U extends AbstractBaseEditorElement>
implements Consumer<Context> {
    @Override
    public void accept(Context context) {
        HashSet processedItem = new HashSet();
        DslSyntaxResolver resolver = context.getResolver();
        this.getModelRootElements(context.getModel()).forEach(operationModel -> {
            DslElementSyntax dslElementSyntax = this.resolveDslElementSyntax(resolver, operationModel);
            U editor = this.process(operationModel, context, dslElementSyntax);
            this.postProcessModelRootElement(operationModel, editor, context, dslElementSyntax);
            processedItem.add(this.getNameFrom(operationModel));
        });
        context.getModel().getConfigurationModels().forEach(config -> this.getModelConfigurationElements((ConfigurationModel)config).forEach(operationModel -> {
            DslElementSyntax dslElementSyntax = this.resolveDslElementSyntax(resolver, operationModel);
            if (!processedItem.contains(this.getNameFrom(operationModel))) {
                U editor = this.process(operationModel, context, dslElementSyntax);
                this.postProcessModelConfigurationElement((T)operationModel, (ConfigurationModel)config, editor, context, dslElementSyntax);
                processedItem.add(this.getNameFrom(operationModel));
            } else {
                AbstractBaseEditorElement editor = (AbstractBaseEditorElement)context.getElementByLocalId(dslElementSyntax.getElementName());
                this.postProcessModelConfigurationElement((T)operationModel, (ConfigurationModel)config, (U)editor, context, dslElementSyntax);
            }
        }));
    }

    protected List<T> getModelRootElements(ExtensionModel extensionModel) {
        return Collections.emptyList();
    }

    protected List<T> getModelConfigurationElements(ConfigurationModel config) {
        return Collections.emptyList();
    }

    protected void postProcessModelRootElement(T operationModel, U editorElement, Context context, DslElementSyntax dslElementSyntax) {
    }

    protected void postProcessModelConfigurationElement(T operationModel, ConfigurationModel config, U editorElement, Context context, DslElementSyntax dslElementSyntax) {
    }

    protected abstract String getNameFrom(T var1);

    protected abstract DslElementSyntax resolveDslElementSyntax(DslSyntaxResolver var1, T var2);

    private U process(T componentModel, Context context, DslElementSyntax dslElementSyntax) {
        U editorElement = this.createEditorModel(componentModel);
        this.configureStereotype(componentModel, editorElement);
        this.configureEditorCommonValues(editorElement, componentModel, context, dslElementSyntax);
        this.configureSpecificEditorProperties(componentModel, editorElement);
        this.configureRequiredSetAlternativesIfRequired(this.getParameterGroupModelsFrom(componentModel), editorElement);
        AttributeCategory attributeCategory = EditorGeneratorUtils.createGeneralTab();
        editorElement.getChildElements().add(attributeCategory);
        this.doProcess(editorElement, attributeCategory, componentModel, context, dslElementSyntax);
        XmlOrderSupplier xmlOrder = new XmlOrderSupplier();
        ArrayList<String> processedParameters = new ArrayList<String>();
        this.processParameters(editorElement, componentModel, context, dslElementSyntax, xmlOrder, processedParameters);
        this.postProcessParameters(editorElement, componentModel, context, dslElementSyntax, xmlOrder, processedParameters);
        this.processNestableElements(editorElement, componentModel, context, dslElementSyntax, xmlOrder);
        this.removeGeneralTabIfEmpty(editorElement, attributeCategory);
        EditorGeneratorUtils.sortElementsByCaption(editorElement.getChildElements());
        this.addToContext(editorElement, componentModel, context);
        return editorElement;
    }

    private void removeGeneralTabIfEmpty(U editorElement, AttributeCategory attributeCategory) {
        if (attributeCategory.getChildElements().isEmpty()) {
            editorElement.getChildElements().remove(attributeCategory);
        }
    }

    private void configureStereotype(T componentModel, U editorElement) {
        StereotypeModel stereotypeFrom = this.getStereotypeFrom(componentModel);
        if (stereotypeFrom != null) {
            this.addStereotypeInformation(editorElement, stereotypeFrom);
        }
    }

    protected void processParameters(U editorElement, T componentModel, Context context, DslElementSyntax dslElementSyntax, XmlOrderSupplier xmlOrderSupplier, List<String> processedParameters) {
        this.getParameterGroupModelsFrom(componentModel).forEach(parameterGroup -> {
            this.processParameterGroup(editorElement, context, dslElementSyntax, xmlOrderSupplier, (ParameterGroupModel)parameterGroup);
            this.postProcessParameterGroup(context, dslElementSyntax, xmlOrderSupplier, (ParameterGroupModel)parameterGroup, processedParameters);
        });
    }

    protected void processParameterGroup(U editorElement, Context context, DslElementSyntax dslElementSyntax, XmlOrderSupplier xmlOrderSupplier, ParameterGroupModel parameterGroup) {
        boolean isGlobalElement = editorElement instanceof AbstractGlobalElement;
        ParameterModelProcessor.getInstance().processParameterGroup(dslElementSyntax.getChild(parameterGroup.getName()), editorElement.getLocalId(), ParametersUtils.buildGroupName((ParameterGroupModel)parameterGroup), editorElement.getChildElements(), parameterGroup, context, xmlOrderSupplier, dslElementSyntax, isGlobalElement);
    }

    private void postProcessParameterGroup(Context context, DslElementSyntax dslElementSyntax, XmlOrderSupplier xmlOrderSupplier, ParameterGroupModel parameterGroup, List<String> processedParameters) {
        if (!parameterGroup.isShowInDsl()) {
            parameterGroup.getParameterModels().stream().map(ParameterModel::getName).forEach(processedParameters::add);
        }
    }

    protected void configureRequiredSetAlternativesIfRequired(List<ParameterGroupModel> parameterModelGroups, U editorElement) {
        parameterModelGroups.forEach(parameterGroup -> {
            if (parameterGroup.getExclusiveParametersModels() != null && !parameterGroup.getExclusiveParametersModels().isEmpty()) {
                RequiredSetAlternatives alternatives = new RequiredSetAlternatives();
                parameterGroup.getExclusiveParametersModels().forEach(model -> {
                    alternatives.setExclusive(Boolean.valueOf(true));
                    alternatives.setRequired(Boolean.valueOf(model.isOneRequired()));
                    model.getExclusiveParameterNames().forEach(value -> {
                        Alternative alternative = new Alternative();
                        alternative.setValue(value);
                        alternatives.getAlternatives().add(alternative);
                    });
                });
                editorElement.getChildElements().add(alternatives);
            }
        });
    }

    protected void postProcessParameters(U editorElement, T componentModel, Context context, DslElementSyntax dslElementSyntax, XmlOrderSupplier xmlOrder, List<String> processedParameters) {
    }

    protected abstract void configureEditorCommonValues(U var1, T var2, Context var3, DslElementSyntax var4);

    protected abstract void configureSpecificEditorProperties(T var1, U var2);

    protected abstract List<ParameterGroupModel> getParameterGroupModelsFrom(T var1);

    protected void processNestableElements(U editorElement, T componentModel, Context context, DslElementSyntax dslElementSyntax, XmlOrderSupplier xmlOrder) {
    }

    protected abstract StereotypeModel getStereotypeFrom(T var1);

    private void addStereotypeInformation(U editorElement, StereotypeModel stereotypeModel) {
        Stereotype stereotype = this.toStereotype(stereotypeModel);
        editorElement.setStereotype(stereotype);
    }

    protected Stereotype toStereotype(StereotypeModel stereotypeModel) {
        Stereotype stereotype = new Stereotype();
        stereotype.setType(stereotypeModel.getType());
        stereotype.setNamespace(stereotypeModel.getNamespace());
        stereotypeModel.getParent().ifPresent(parent -> {
            Stereotype parentStereotype = this.toStereotype((StereotypeModel)parent);
            stereotype.setParent(parentStereotype);
        });
        return stereotype;
    }

    protected Set<ErrorModel> getErrorModels(T componentModel) {
        return Collections.emptySet();
    }

    protected Optional<MetadataKeyIdModel> getMetadataKeyIdModel(T componentModel) {
        return Optional.empty();
    }

    protected abstract U createEditorModel(T var1);

    protected abstract void doProcess(U var1, AttributeCategory var2, T var3, Context var4, DslElementSyntax var5);

    protected abstract void addToContext(U var1, T var2, Context var3);
}

