/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.customization;

import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.extension.api.IFieldEditorProvider;
import org.mule.tooling.internal.customization.CustomEditorProvider;

public class EditorProviderMatcher {
    private static final String VERSION_RANGE = "[\\[\\(].*[\\)\\]]";
    private static final Pattern VERSION_RANGE_PATTERN = Pattern.compile("[\\[\\(].*[\\)\\]]");
    private String versionRange;
    private IFieldEditorProvider fieldProvider;
    private CustomEditorProvider editorProvider;
    private static final String EDITOR_PROVIDER_ISSUE = "There was a problem while trying to match one of the editor providers, please check your contribution to the editorProvider extension point";

    public EditorProviderMatcher(String versionRange, IFieldEditorProvider fieldProvider) {
        this.fieldProvider = fieldProvider;
        this.versionRange = this.treatRecommendationAsSpecificVersion(versionRange);
    }

    private String treatRecommendationAsSpecificVersion(String versionRange) {
        Object finalVersionRange = versionRange;
        if (!VERSION_RANGE_PATTERN.matcher(versionRange).matches()) {
            finalVersionRange = "[" + versionRange + "]";
        }
        return finalVersionRange;
    }

    public EditorProviderMatcher(String versionRange, CustomEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
        this.versionRange = this.treatRecommendationAsSpecificVersion(versionRange);
    }

    public boolean matches(String version) {
        try {
            return VersionRange.createFromVersionSpec((String)this.versionRange).containsVersion((ArtifactVersion)new DefaultArtifactVersion(version));
        }
        catch (InvalidVersionSpecificationException e) {
            MuleCorePlugin.logError((String)EDITOR_PROVIDER_ISSUE, (Throwable)e);
            return false;
        }
    }

    public Optional<IFieldEditorProvider> getFieldEditorProvider() {
        return Optional.ofNullable(this.fieldProvider);
    }

    public Optional<CustomEditorProvider> getCustomEditorProvider() {
        return Optional.ofNullable(this.editorProvider);
    }
}

