/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.customization;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.module.contribution.BundleId;
import org.mule.tooling.extension.api.IFieldEditorProvider;
import org.mule.tooling.internal.customization.CustomEditorProvider;
import org.mule.tooling.internal.customization.EditorProviderMatcher;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class CustomizationManager {
    private static final String SEPARATOR = ":";
    private static CustomizationManager INSTANCE;
    private Map<String, List<EditorProviderMatcher>> fieldEditorProviders = new HashMap<String, List<EditorProviderMatcher>>();
    private Map<String, List<EditorProviderMatcher>> customEditors = new HashMap<String, List<EditorProviderMatcher>>();

    public static CustomizationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomizationManager();
        }
        return INSTANCE;
    }

    private CustomizationManager() {
        this.loadProviders();
    }

    private void loadProviders() {
        this.loadAttributeProviders();
        this.loadCustomEditorProvider();
    }

    private void loadAttributeProviders() {
        String extensionPointId = "org.mule.tooling.extension.api.editorProvider";
        ArrayList configurationElements = Lists.newArrayList((Object[])Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId));
        configurationElements.stream().filter(element -> element.getName().equals("attributeProvider")).forEach(element -> {
            try {
                String path = element.getAttribute("path");
                String version = element.getAttribute("version");
                String extension = element.getAttribute("extension");
                Object fieldEditor = element.createExecutableExtension("factory");
                if (fieldEditor != null) {
                    String key = extension + SEPARATOR + path;
                    EditorProviderMatcher matcher = new EditorProviderMatcher(version, (IFieldEditorProvider)fieldEditor);
                    this.cacheProviderMatcher(key, matcher, this.getFieldProviders());
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("Error while retrieving extension point objects from " + extensionPointId), (Throwable)e);
            }
        });
    }

    private void cacheProviderMatcher(String key, EditorProviderMatcher matcher, Map<String, List<EditorProviderMatcher>> providers) {
        List<EditorProviderMatcher> customEditorMatchers = providers.get(key);
        if (customEditorMatchers == null) {
            ArrayList<EditorProviderMatcher> newCustomProviders = new ArrayList<EditorProviderMatcher>();
            newCustomProviders.add(matcher);
            providers.put(key, newCustomProviders);
        } else {
            customEditorMatchers.add(matcher);
        }
    }

    private void loadCustomEditorProvider() {
        List customEditorProviders = IExtensionPointReader.create(CustomEditorProvider.class).readAll();
        customEditorProviders.stream().forEach(customEditorProvider -> {
            String groupIdArtifactId = customEditorProvider.getGA();
            EditorProviderMatcher editorMatcher = new EditorProviderMatcher(customEditorProvider.getVersion(), (CustomEditorProvider)customEditorProvider);
            this.cacheProviderMatcher(groupIdArtifactId, editorMatcher, this.getCustomEditors());
        });
    }

    public Optional<IFieldEditorProvider> getCustomizationFor(String extension, String operationName, String path, String version) {
        List<EditorProviderMatcher> editorProviderMatchers = this.getFieldProviders().get(extension + SEPARATOR + operationName + "/" + this.computeLastSegment(path));
        if (editorProviderMatchers != null) {
            return editorProviderMatchers.stream().filter(editorProviderMatcher -> editorProviderMatcher.matches(version) && editorProviderMatcher.getFieldEditorProvider().isPresent()).map(EditorProviderMatcher::getFieldEditorProvider).map(Optional::get).findFirst();
        }
        return Optional.empty();
    }

    public Optional<BundleId> getCustomizationBundleId(MavenDependency dependency) {
        return this.mapMatchingCustomEditorTo(dependency, x -> new BundleId(x.getBundle().getSymbolicName(), org.mule.tooling.core.module.contribution.Version.from((Version)x.getBundle().getVersion())));
    }

    private <T> Optional<T> mapMatchingCustomEditorTo(MavenDependency dependency, Function<CustomEditorProvider, T> mapping) {
        Map<String, List<EditorProviderMatcher>> savedCustomEditors = this.getCustomEditors();
        List<EditorProviderMatcher> possibleCustomEditorProviders = savedCustomEditors.get(MavenUtils.getGA((MavenDependency)dependency));
        if (possibleCustomEditorProviders != null) {
            Optional<CustomEditorProvider> foundCustomEditorProvider = possibleCustomEditorProviders.stream().filter(customEditorProvider -> customEditorProvider.matches(dependency.getVersion()) && customEditorProvider.getCustomEditorProvider().isPresent()).map(EditorProviderMatcher::getCustomEditorProvider).map(Optional::get).findFirst();
            return foundCustomEditorProvider.isPresent() ? Optional.ofNullable(mapping.apply(foundCustomEditorProvider.get())) : Optional.empty();
        }
        return Optional.empty();
    }

    public Optional<URL> customEditorPath(MavenDependency dependency) {
        return this.mapMatchingCustomEditorTo(dependency, x -> FileLocator.find((Bundle)x.getBundle(), (IPath)new Path(x.getPath()), null));
    }

    public Map<String, List<EditorProviderMatcher>> getFieldProviders() {
        return this.fieldEditorProviders;
    }

    public Map<String, List<EditorProviderMatcher>> getCustomEditors() {
        return this.customEditors;
    }

    private String computeLastSegment(String path) {
        return path.lastIndexOf(47) != -1 ? path.substring(path.lastIndexOf(47) + 1) : path;
    }
}

