/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.extension.api.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.SubTypesModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.editor.model.Namespace;
import org.mule.tooling.editor.model.contribution.AbstractContributionEditorElement;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.contribution.Route;
import org.mule.tooling.editor.model.contribution.global.AbstractGlobalElement;
import org.mule.tooling.editor.model.contribution.global.Global;
import org.mule.tooling.extension.api.generation.ValuePartContainer;

public class Context {
    private final String moduleId;
    private final List<AbstractContributionEditorElement> operations;
    private final List<AbstractContributionEditorElement> sources;
    private final Map<ConfigurationModel, AbstractGlobalElement> configurations;
    private final Set<String> optionalConfigurations;
    private final List<Nested> conectionProviders;
    private final Map<String, List<String>> operationsAssociatedConfig;
    private final Map<String, List<String>> sourcesAssociatedConfig;
    private final Map<String, List<Nested>> providersByConfig;
    private final Map<String, Nested> nestedElements;
    private final Map<String, Route> routeElements;
    private final Map<String, Global> globalElements;
    private final DslSyntaxResolver resolver;
    private int totalOperations = 0;
    private int totalSources = 0;
    private final Map<MetadataType, MetadataType> typeToBaseType;
    private final ExtensionModel model;
    private final Namespace namespace;
    private Stack<MetadataType> typeStack = new Stack();
    private ValuePartContainer keyPartContainer = new ValuePartContainer();
    private String operationName;

    public int getTotalOperations() {
        return this.totalOperations;
    }

    public int getTotalSources() {
        return this.totalSources;
    }

    public Context(String moduleId, ExtensionModel model, DslSyntaxResolver dslSyntaxResolver) {
        this.model = model;
        this.moduleId = moduleId;
        this.namespace = new Namespace();
        this.operations = new ArrayList<AbstractContributionEditorElement>();
        this.sources = new ArrayList<AbstractContributionEditorElement>();
        this.configurations = new HashMap<ConfigurationModel, AbstractGlobalElement>();
        this.conectionProviders = new ArrayList<Nested>();
        this.nestedElements = new HashMap<String, Nested>();
        this.routeElements = new HashMap<String, Route>();
        this.globalElements = new HashMap<String, Global>();
        this.operationsAssociatedConfig = new HashMap<String, List<String>>();
        this.sourcesAssociatedConfig = new HashMap<String, List<String>>();
        this.providersByConfig = new HashMap<String, List<Nested>>();
        this.typeToBaseType = new HashMap<MetadataType, MetadataType>();
        this.optionalConfigurations = new HashSet<String>();
        this.resolver = dslSyntaxResolver;
        this.init();
    }

    private void init() {
        this.totalOperations = this.model.getOperationModels().size();
        this.totalSources = this.model.getSourceModels().size();
        for (ConfigurationModel config : this.getModel().getConfigurationModels()) {
            DslElementSyntax configDsl = this.resolver.resolve(config);
            for (OperationModel operationModel : config.getOperationModels()) {
                ++this.totalOperations;
                DslElementSyntax operationDsl = this.resolver.resolve(operationModel);
                this.linkOperationWithConfig(operationDsl.getElementName(), configDsl.getElementName());
            }
            for (SourceModel sourceModel : config.getSourceModels()) {
                ++this.totalSources;
                DslElementSyntax sourceDsl = this.resolver.resolve(sourceModel);
                this.linkSourcesWithConfig(sourceDsl.getElementName(), configDsl.getElementName());
            }
        }
        Set subtypesProperty = this.model.getSubTypes();
        for (SubTypesModel entry : subtypesProperty) {
            ObjectType baseType = entry.getBaseType();
            for (MetadataType subType : entry.getSubTypes()) {
                this.typeToBaseType.put(subType, (MetadataType)baseType);
            }
        }
    }

    public void addOperation(AbstractContributionEditorElement operation) {
        this.operations.add(operation);
        this.namespace.getComponents().add(operation);
    }

    public void addSource(AbstractContributionEditorElement source) {
        this.sources.add(source);
        this.namespace.getComponents().add(source);
    }

    public void addConfiguration(ConfigurationModel configurationModel, AbstractGlobalElement configuration, boolean isOptional) {
        this.configurations.put(configurationModel, configuration);
        if (isOptional) {
            this.optionalConfigurations.add(configuration.getLocalId());
        }
        this.namespace.getComponents().add(configuration);
    }

    public List<Nested> getConectionProviders() {
        return this.conectionProviders;
    }

    public void addConnectionProvider(Nested connectionProvider) {
        this.conectionProviders.add(connectionProvider);
        this.namespace.getComponents().add(connectionProvider);
    }

    public boolean containsNested(String nestedId) {
        return this.nestedElements.containsKey(nestedId);
    }

    public void addNested(Nested nested) {
        this.nestedElements.put(nested.getLocalId(), nested);
        this.namespace.getComponents().add(nested);
    }

    public Nested getNested(String nestedId) {
        return this.nestedElements.get(nestedId);
    }

    public void addRoute(Route route) {
        this.routeElements.put(route.getLocalId(), route);
        this.namespace.getComponents().add(route);
    }

    public Route getRoute(String nestedId) {
        return this.routeElements.get(nestedId);
    }

    public boolean containsGlobal(String globalId) {
        return this.globalElements.containsKey(globalId);
    }

    public void addGlobal(Global global) {
        this.globalElements.put(global.getLocalId(), global);
        this.namespace.getComponents().add(global);
    }

    public Global getGlobal(String globalId) {
        return this.globalElements.get(globalId);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public ExtensionModel getModel() {
        return this.model;
    }

    private void linkOperationWithConfig(String operation, String config) {
        List configs = this.operationsAssociatedConfig.computeIfAbsent(operation, f -> new ArrayList());
        if (!configs.contains(config)) {
            configs.add(config);
        }
    }

    public Optional<List<String>> getAssociatedConfigs(String operation) {
        return Optional.ofNullable(this.operationsAssociatedConfig.get(operation));
    }

    private void linkSourcesWithConfig(String operation, String config) {
        List configs = this.sourcesAssociatedConfig.computeIfAbsent(operation, f -> new ArrayList());
        if (!configs.contains(config)) {
            configs.add(config);
        }
    }

    public Optional<List<String>> getSourceAssociatedConfig(String operation) {
        return Optional.ofNullable(this.sourcesAssociatedConfig.get(operation));
    }

    public void linkProviderWithConfig(String config, Nested provider) {
        List providers = this.providersByConfig.computeIfAbsent(config, f -> new ArrayList());
        if (!providers.contains(provider)) {
            providers.add(provider);
        }
    }

    public List<Nested> getProviders(String config) {
        return Optional.ofNullable(this.providersByConfig.get(config)).orElse(Collections.emptyList());
    }

    public Map<String, List<Nested>> getProvidersByConfig() {
        return this.providersByConfig;
    }

    public Boolean hasSubTypes(MetadataType metadataType) {
        if (metadataType instanceof ObjectType) {
            return !this.resolver.getSubTypes((ObjectType)metadataType).isEmpty();
        }
        return false;
    }

    public Set<ObjectType> getSubTypes(MetadataType metadataType) {
        Optional<SubTypesModel> subtypesProperty = this.getModel().getSubTypes().stream().filter(s -> s.getBaseType().equals(metadataType)).findFirst();
        if (subtypesProperty.isPresent()) {
            return subtypesProperty.get().getSubTypes();
        }
        return Collections.emptySet();
    }

    public DslSyntaxResolver getResolver() {
        return this.resolver;
    }

    public boolean belongsToCurrentNamespace(DslElementSyntax element) {
        return this.getNamespace().getUrl().equals(element.getNamespace());
    }

    public Optional<MetadataType> getBaseType(ObjectType type) {
        return Optional.ofNullable(this.typeToBaseType.get(type));
    }

    public void pushType(MetadataType type) {
        this.typeStack.push(type);
    }

    public void popType() {
        this.typeStack.pop();
    }

    public boolean containsType(MetadataType type) {
        return this.typeStack.contains(type);
    }

    public ValuePartContainer getKeyPartContainer() {
        return this.keyPartContainer;
    }

    public boolean hasConnectionProviders() {
        return !this.model.getConnectionProviders().isEmpty() || this.model.getConfigurationModels().stream().flatMap(config -> config.getConnectionProviders().stream()).findFirst().isPresent();
    }

    public boolean areAllConfigsOptionals(List<String> configs) {
        return this.optionalConfigurations.containsAll(configs);
    }

    public <T> T getElementByLocalId(String localId) {
        return (T)this.getNamespace().getComponents().stream().filter(x -> x.getLocalId().equals(localId)).findFirst().orElseThrow(() -> new RuntimeException("Unable to locate element with id: " + localId));
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public boolean isProcessingConfiglessElement() {
        String currentOperation = this.getOperationName();
        return this.getAssociatedConfigs(currentOperation).isPresent() || this.getSourceAssociatedConfig(currentOperation).isPresent();
    }
}

