/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.extension.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.editor.model.Namespace;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.AppConfigItemProcessor;
import org.mule.tooling.internal.extension.api.ConfigurationItemProcessor;
import org.mule.tooling.internal.extension.api.ConfigurationsPostProcessor;
import org.mule.tooling.internal.extension.api.ConnectionProviderItemProcessor;
import org.mule.tooling.internal.extension.api.ConstructsItemProcessor;
import org.mule.tooling.internal.extension.api.NamespaceInitializer;
import org.mule.tooling.internal.extension.api.OperationItemProcessor;
import org.mule.tooling.internal.extension.api.SourceItemProcessor;
import org.mule.tooling.internal.extension.api.SubtypesProcessor;
import org.mule.tooling.internal.extension.api.TypesProcessor;

public final class StudioEditorGenerator {
    private List<Consumer<Context>> executionChain = new ArrayList<Consumer<Context>>();

    private StudioEditorGenerator() {
    }

    protected void buildExecutionChain() {
        this.executionChain.add(new NamespaceInitializer());
        this.executionChain.add(new SubtypesProcessor());
        this.executionChain.add(new TypesProcessor());
        this.executionChain.add(new ConnectionProviderItemProcessor());
        this.executionChain.add(new ConfigurationItemProcessor());
        this.executionChain.add(new ConfigurationsPostProcessor());
        this.executionChain.add(new OperationItemProcessor());
        this.executionChain.add(new SourceItemProcessor());
        this.executionChain.add(new ConstructsItemProcessor());
        this.executionChain.add(new AppConfigItemProcessor());
    }

    public static StudioEditorGenerator newStudioEditorGenerator() {
        StudioEditorGenerator generator = new StudioEditorGenerator();
        return generator;
    }

    public Namespace build(String moduleId, ExtensionModel extensionModel, DslSyntaxResolver dslResolvingContext) {
        Context context = new Context(moduleId, extensionModel, dslResolvingContext);
        this.buildExecutionChain();
        this.executionChain.forEach(consumer -> consumer.accept(context));
        return context.getNamespace();
    }
}

