/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.extension.api;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.XmlDslModel;
import org.mule.tooling.core.JAXBContextHelper;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.contribution.ErrorModelMapper;
import org.mule.tooling.core.module.contribution.ExternalContribution;
import org.mule.tooling.core.module.contribution.ExternalLibraryMapper;
import org.mule.tooling.core.module.internal.IModuleHandler;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.ExtensionModelLoadException;
import org.mule.tooling.core.utils.ExtensionModelLoaderUtils;
import org.mule.tooling.core.utils.Tuple;
import org.mule.tooling.core.xml.XmlFactoryUtils;
import org.mule.tooling.editor.model.Namespace;
import org.mule.tooling.extension.api.BaseModuleHandler;
import org.mule.tooling.extension.api.ExtensionDiscovererUtils;
import org.mule.tooling.internal.core.module.JarBasedArtifact;
import org.mule.tooling.internal.customization.CustomizationManager;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.generation.CachingDslElementSytaxResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SingleExtensionModuleHandler
extends BaseModuleHandler {
    private static final String UNDEFINED_SCHEMA_COMPONENT = "STUDIO-UNDEF-S750";
    private static final String UNDEFINED_PROPERTY_VALUE = "N/A";
    private static final String UNDEFINED_DESCRIPTION = "Not available";

    public static Optional<IModuleHandler<ExternalContributionMuleModule>> create(String serverVersion, MavenDependency dependency, List<Repository> repositories, Consumer<ExternalContribution> consumer) {
        try {
            Optional extensionModel = ExtensionModelLoaderUtils.getExtensionModel((MavenDependency)dependency, (String)serverVersion, repositories);
            if (extensionModel.isPresent()) {
                return Optional.of(new SingleExtensionModuleHandler((ExtensionModel)((Tuple)extensionModel.get()).first(), dependency, (DslSyntaxResolver)((Tuple)extensionModel.get()).second(), consumer));
            }
            return Optional.of(new SingleExtensionModuleHandler(dependency));
        }
        catch (ExtensionModelLoadException e) {
            MuleCorePlugin.logError((String)("Error while loading model for: " + MavenUtils.getGAV((MavenDependency)dependency) + ". This dependency wont have an UI to configure it."), (Throwable)e);
            return Optional.empty();
        }
    }

    public SingleExtensionModuleHandler(ExtensionModel model, MavenDependency dependency, DslSyntaxResolver dslResolvingContext, Consumer<ExternalContribution> consumer) {
        this.init(model, dependency, CachingDslElementSytaxResolver.createWith(dslResolvingContext), consumer);
    }

    public SingleExtensionModuleHandler(MavenDependency dependency, ExternalContribution editor) {
        File mavenDependencyLocalFile = CoreUtils.getFileInLocalRepo((MavenDependency)dependency);
        String contributionJarName = mavenDependencyLocalFile.getName();
        try {
            String name = editor.getName();
            String version = editor.getVersion();
            String id = MavenUtils.getGAV((MavenDependency)dependency);
            JarBasedArtifact muleArtifact = new JarBasedArtifact(id, version, mavenDependencyLocalFile);
            String description = editor.getDescription();
            String namespace = editor.getEditor().getUrl();
            String prefix = editor.getEditor().getPrefix();
            String schemaLocation = editor.getSchemaLocation();
            String iconPath = editor.getIcon();
            Set errorModels = editor.getErrorModels();
            Set externalLibraryModels = editor.getExternalLibraries();
            this.buildModule(dependency, (Artifact)muleArtifact, name, description, namespace, prefix, schemaLocation, contributionJarName, errorModels, externalLibraryModels, iconPath, this.getDoc(editor.getEditor()));
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)("Unexpected error loading contribution from: " + contributionJarName), (Throwable)e);
        }
    }

    public SingleExtensionModuleHandler(MavenDependency dependency) {
        File mavenDependencyLocalFile = CoreUtils.getFileInLocalRepo((MavenDependency)dependency);
        String contributionJarName = mavenDependencyLocalFile.getName();
        String id = MavenUtils.getGAV((MavenDependency)dependency);
        String version = dependency.getVersion();
        JarBasedArtifact muleArtifact = new JarBasedArtifact(id, version, mavenDependencyLocalFile);
        try {
            this.buildModule(dependency, (Artifact)muleArtifact, dependency.getArtifactId(), UNDEFINED_DESCRIPTION, UNDEFINED_SCHEMA_COMPONENT, UNDEFINED_SCHEMA_COMPONENT, UNDEFINED_SCHEMA_COMPONENT, contributionJarName, Collections.emptySet(), Collections.emptySet(), UNDEFINED_PROPERTY_VALUE, this.getDoc(new Namespace()));
        }
        catch (JAXBException e) {
            MuleCorePlugin.logError((String)"Unexpected error", (Throwable)e);
        }
    }

    private void init(ExtensionModel model, MavenDependency dependency, DslSyntaxResolver dslResolvingContext, Consumer<ExternalContribution> consumer) {
        File mavenDependencyLocalFile = CoreUtils.getFileInLocalRepo((MavenDependency)dependency);
        String contributionJarName = mavenDependencyLocalFile.getName();
        try {
            String id = MavenUtils.getGAV((MavenDependency)dependency);
            String name = model.getName();
            String version = model.getVersion();
            JarBasedArtifact muleArtifact = new JarBasedArtifact(id, version, mavenDependencyLocalFile);
            String description = model.getDescription();
            XmlDslModel xmlDslModel = model.getXmlDslModel();
            String namespace = xmlDslModel.getNamespace();
            String prefix = xmlDslModel.getPrefix();
            String schemaLocation = xmlDslModel.getSchemaLocation();
            Set errorModels = model.getErrorModels();
            Set externalLibraryModels = model.getExternalLibraryModels();
            Namespace document = this.getDocument(id, model, dslResolvingContext, dependency);
            ExternalContribution contribution = new ExternalContribution();
            contribution.setName(name);
            contribution.setVersion(version);
            contribution.setEditor(document);
            contribution.setDescription(description);
            contribution.setSchemaLocation(schemaLocation);
            contribution.setErrorModels(ErrorModelMapper.toErrorModels((Set)errorModels));
            contribution.setExternalLibraries(ExternalLibraryMapper.toExternalLibraries((Set)externalLibraryModels));
            contribution.setIcon(EditorGeneratorUtils.getSmallIconPath(id, document));
            contribution.setImage(EditorGeneratorUtils.getLargeIconPath(id, document));
            CustomizationManager.getInstance().getCustomizationBundleId(dependency).ifPresent(arg_0 -> ((ExternalContribution)contribution).setCustomUIBundleID(arg_0));
            consumer.accept(contribution);
            this.buildModule(dependency, (Artifact)muleArtifact, name, description, namespace, prefix, schemaLocation, contributionJarName, contribution.getErrorModels(), contribution.getExternalLibraries(), contribution.getIcon(), this.getDoc(document));
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)("Unexpected error loading contribution from: " + contributionJarName), (Throwable)e);
        }
    }

    private Document getDoc(Namespace editor) throws JAXBException {
        DocumentBuilder db = XmlFactoryUtils.createSecureDocumentBuilder();
        Document document = db.newDocument();
        Marshaller marshaller = JAXBContextHelper.getInstance().getMarshaller();
        marshaller.marshal((Object)editor, (Node)document);
        return document;
    }

    private Namespace getDocument(String moduleId, ExtensionModel model, DslSyntaxResolver dslResolvingContext, MavenDependency dependency) throws JAXBException {
        Optional<Namespace> customUI = this.getCustomUI(dependency);
        return this.getDocumentFromModel(moduleId, model, dslResolvingContext, customUI);
    }

    private Optional<Namespace> getCustomUI(MavenDependency dependency) throws JAXBException {
        Optional<URL> customEditorPath = CustomizationManager.getInstance().customEditorPath(dependency);
        if (customEditorPath.isPresent()) {
            Unmarshaller jaxbUnmarshaller = JAXBContextHelper.getInstance().getUnmarshaller();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream stream = customEditorPath.get().openStream();){
                    return Optional.ofNullable((Namespace)jaxbUnmarshaller.unmarshal(stream));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)"Unable to parse file to document", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private Namespace getDocumentFromModel(String moduleId, ExtensionModel model, DslSyntaxResolver dslResolvingContext, Optional<Namespace> customUI) {
        Namespace editorModel = ExtensionDiscovererUtils.getEditorModelFrom(moduleId, model, dslResolvingContext);
        if (customUI.isPresent()) {
            editorModel = ExtensionDiscovererUtils.merge(customUI.get(), editorModel);
        }
        return editorModel;
    }

    public String toString() {
        return "SingleExtensionModuleHandler [muleModule=" + String.valueOf(this.muleModule) + "]";
    }

    public static Optional<IModuleHandler<ExternalContributionMuleModule>> create(MavenDependency dependency, ExternalContribution editor) {
        File fileInLocalRepo = CoreUtils.getFileInLocalRepo((MavenDependency)dependency);
        if (fileInLocalRepo.exists()) {
            return Optional.of(new SingleExtensionModuleHandler(dependency, editor));
        }
        return Optional.empty();
    }
}

