/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.extension.api;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.IModuleHandlerFactory;
import org.mule.tooling.core.module.contribution.BundleId;
import org.mule.tooling.core.module.contribution.ExternalContribution;
import org.mule.tooling.core.module.internal.IModuleHandler;
import org.mule.tooling.core.tooling.ToolingCachePathUtils;
import org.mule.tooling.extension.api.SingleExtensionModuleHandler;
import org.mule.tooling.internal.customization.CustomizationManager;
import org.mule.tooling.internal.extension.api.generation.ExternalContributionSerializer;

public class ModuleHandlerFactory
implements IModuleHandlerFactory<ExternalContributionMuleModule> {
    private final ExternalContributionSerializer cache;
    private final CustomizationManager customizationManager;

    public ModuleHandlerFactory() {
        this(new ExternalContributionSerializer(ToolingCachePathUtils.getEditorsCachePath().toFile().toPath()), CustomizationManager.getInstance());
    }

    public ModuleHandlerFactory(ExternalContributionSerializer cacheSerializer, CustomizationManager customizationManager) {
        this.cache = cacheSerializer;
        this.customizationManager = customizationManager;
    }

    public Optional<IModuleHandler<ExternalContributionMuleModule>> createHandlerFor(String muleVersion, MavenDependency dependency, List<Repository> repositories) {
        Optional<ExternalContribution> contribution = this.cache.getExternalContributionFor(muleVersion, dependency);
        if (contribution.isPresent()) {
            try {
                Optional<IModuleHandler<ExternalContributionMuleModule>> handlerFromCache;
                if (this.storedCustomizationIdMatchesCurrentContribution(contribution.get(), dependency) && (handlerFromCache = SingleExtensionModuleHandler.create(dependency, contribution.get())).isPresent()) {
                    return handlerFromCache;
                }
            }
            catch (Exception exception) {}
        }
        return this.createFromRepository(muleVersion, dependency, repositories);
    }

    protected Optional<IModuleHandler<ExternalContributionMuleModule>> createFromRepository(String muleVersion, MavenDependency dependency, List<Repository> repositories) {
        return SingleExtensionModuleHandler.create(muleVersion, dependency, repositories, newContribution -> this.cache.saveExternalContribution(muleVersion, dependency, (ExternalContribution)newContribution));
    }

    public boolean storedCustomizationIdMatchesCurrentContribution(ExternalContribution readObject, MavenDependency dependency) {
        Optional<BundleId> customEditorPath = this.customizationManager.getCustomizationBundleId(dependency);
        if (customEditorPath.isPresent()) {
            return customEditorPath.get().equals((Object)readObject.getCustomUIBundleID());
        }
        return Objects.isNull(readObject.getCustomUIBundleID());
    }
}

