/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.extension.api;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.event.DefaultModulesLoadedEvent;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.module.FeaturedModulesInitializer;
import org.mule.tooling.core.module.FeaturedModulesTracker;
import org.mule.tooling.core.module.IModuleContributionManager;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.extension.api.ModuleHandlerFactory;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class ExtensionModelBasedFeaturedModulesInitializer
implements FeaturedModulesInitializer {
    protected static final int TASK_SIZE = 100;
    private final EventBus eventBus;

    public ExtensionModelBasedFeaturedModulesInitializer() {
        this((EventBus)EclipseContextHelper.getFromStudioContext(EventBus.class));
    }

    public ExtensionModelBasedFeaturedModulesInitializer(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void loadModulesFor(IServerDefinition serverDefinition, IModuleContributionManager moduleContributionManager, IProgressMonitor monitor) {
        FeaturedModulesTracker instance = FeaturedModulesTracker.instance();
        if (!instance.stateUnknown(serverDefinition.getId())) {
            throw new IllegalStateException("Should never request to load featured modules for a server definitionmore than once. Server Id: " + serverDefinition.getId());
        }
        instance.setLoadingState(serverDefinition.getId());
        ModuleHandlerFactory factory = new ModuleHandlerFactory();
        long startFeaturedModules = System.currentTimeMillis();
        String muleVersion = serverDefinition.getVersionWithSuffix();
        List<MavenDependency> extensionModelFromRuntime = ExtensionModelBasedFeaturedModulesInitializer.getDefaultExtensionsFor(serverDefinition);
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Resolving extension models", (int)100);
            if (!extensionModelFromRuntime.isEmpty()) {
                int stepSize = 100 / extensionModelFromRuntime.size();
                for (MavenDependency dependency : extensionModelFromRuntime) {
                    subMonitor.split(stepSize).subTask("Creating module for " + MavenUtils.getGAV((MavenDependency)dependency));
                    factory.createHandlerFor(muleVersion, dependency, Collections.emptyList()).ifPresent(x -> moduleContributionManager.addHandlerIfAbsent(serverDefinition, dependency, x));
                }
            }
        }
        finally {
            long endFeaturedModules = System.currentTimeMillis();
            long duration = endFeaturedModules - startFeaturedModules;
            this.trackFeaturedModulesLoadingTime(muleVersion, duration, extensionModelFromRuntime);
            instance.setLoadedState(serverDefinition.getId());
            this.eventBus.fireEvent((IEvent)DefaultModulesLoadedEvent.newDefaultModulesLoadedEvent((IServerDefinition)serverDefinition));
        }
    }

    protected void trackFeaturedModulesLoadingTime(String muleVersion, long duration, List<MavenDependency> extensionModelFromRuntime) {
        AnalyticsRecordsFactory.single((String)Events.FEATURED_MODULES_INITIALIZED, (String[])new String[]{"muleVersion", muleVersion, "timeInMillis", String.valueOf(duration), "modules", extensionModelFromRuntime.stream().map(MavenUtils::getGAV).collect(Collectors.joining(","))}).track();
    }

    public static List<MavenDependency> getDefaultExtensionsFor(IServerDefinition serverDefinition) {
        if (serverDefinition.getPluginBaseDirectory() == null) {
            return Collections.emptyList();
        }
        return MavenCore.getPomDefaultsHandlerManager().findProviderFor(serverDefinition).getDefaultExtensions().stream().filter(x -> !MavenUtils.EXTENSIONS_WITH_NO_MODEL.contains(MavenUtils.getGA((MavenDependency)x))).collect(Collectors.toList());
    }
}

