/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.extension.api;

import java.util.Map;
import java.util.stream.Collectors;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.editor.model.AbstractBaseEditorElement;
import org.mule.tooling.editor.model.Namespace;
import org.mule.tooling.extension.api.StudioEditorGenerator;
import org.mule.tooling.utils.Pair;

public class ExtensionDiscovererUtils {
    private ExtensionDiscovererUtils() {
    }

    public static Namespace getEditorModelFrom(String moduleId, ExtensionModel extensionModel, DslSyntaxResolver dslResolvingContext) {
        StudioEditorGenerator studioEditorGenerator = StudioEditorGenerator.newStudioEditorGenerator();
        return studioEditorGenerator.build(moduleId, extensionModel, dslResolvingContext);
    }

    public static Namespace merge(Namespace base, Namespace other) {
        Namespace merged = new Namespace();
        try {
            Map<Pair, AbstractBaseEditorElement> componentsById = base.getComponents().stream().collect(Collectors.toMap(p -> new Pair((Object)p.getLocalId(), (Object)p.getClass().getName()), p -> p));
            merged.setDeprecatedMessage(base.getDeprecatedMessage());
            merged.setDeprecatedVersions(base.getDeprecatedVersions());
            merged.setPrefix(base.getPrefix());
            merged.setUrl(base.getUrl());
            merged.setVersions(base.getVersions());
            merged.getComponents().addAll(base.getComponents());
            other.getComponents().stream().filter(x -> !componentsById.containsKey(new Pair((Object)x.getLocalId(), (Object)x.getClass().getName()))).forEach(component -> merged.getComponents().add(component));
        }
        catch (Exception exception) {
            return base;
        }
        return merged;
    }
}

