/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.extension.api;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.contribution.ErrorModel;
import org.mule.tooling.core.module.contribution.ExternalLibraryModel;
import org.mule.tooling.core.module.internal.IModuleHandler;
import org.mule.tooling.core.module.internal.IOverrideHandler;
import org.mule.tooling.model.module.NodeDefinition;
import org.w3c.dom.Document;

public abstract class BaseModuleHandler
implements IModuleHandler<ExternalContributionMuleModule> {
    protected ExternalContributionMuleModule muleModule;

    protected void buildModule(MavenDependency dependency, Artifact muleArtifact, String name, String description, String namespace, String prefix, String schemaLocation, String contributionJarName, Set<ErrorModel> errorModels, Set<ExternalLibraryModel> externalLibraryModels, String iconPath, Document editorDocument) {
        this.muleModule = new ExternalContributionMuleModule((MavenCoordinates)dependency, (MuleModule.ModeOperationOverrideModuleLoaderHandler)new ExternalContributionMuleModule.ExternalModeOperationOverrideModuleLoaderHandler((IOverrideHandler)this));
        this.muleModule.setDescription(description);
        this.muleModule.setContributionNamespace(namespace);
        this.muleModule.setContributionNamespacePrefix(prefix);
        this.muleModule.setContributionNamespaceFile(schemaLocation);
        this.muleModule.setContributionLibs("META-INF" + File.separatorChar + "mule-artifact" + File.separatorChar + "repository");
        this.muleModule.setContributionJar(contributionJarName);
        this.muleModule.setName(name);
        this.muleModule.setContributionLibPathInMule("/plugins");
        this.muleModule.setVersion(dependency.getVersion());
        this.muleModule.setMaximumVersion("10.0.0");
        this.muleModule.setIconPath(iconPath);
        this.muleModule.setErrorModels(errorModels);
        this.muleModule.initialize(muleArtifact, editorDocument);
        if (!externalLibraryModels.isEmpty()) {
            this.configureRequiredLibraries(externalLibraryModels);
        }
    }

    protected void configureRequiredLibraries(Set<ExternalLibraryModel> externalLibraryModels) {
        externalLibraryModels.stream().filter(x -> !x.isOptional() && x.getSuggestedCoordinates().isPresent()).forEach(dependency -> {
            String gav = (String)dependency.getSuggestedCoordinates().get();
            String[] mavenCoords = gav.split(":");
            if (mavenCoords.length == 3) {
                this.muleModule.getRequiredLibraries().add(((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(mavenCoords[0])).withArtifactId(mavenCoords[1])).withVersion(mavenCoords[2])).beingShared(true)).build());
            } else {
                MuleCorePlugin.logWarning((String)("Unexpected maven coordinates suggestion: " + gav));
            }
        });
    }

    public void registerModeOperationOverride(NodeDefinition nodeDefinition, String operationName) {
    }

    public List<ExternalContributionMuleModule> getModules() {
        List<ExternalContributionMuleModule> modules = this.muleModule != null ? Arrays.asList(this.muleModule) : Collections.emptyList();
        return modules;
    }

    public String getUniqueIdentifier() {
        return this.muleModule.getId();
    }
}

