/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.utils;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.client.Activator;
import org.mule.tooling.core.jvm.JVMHelper;

public class ToolingVMHelper {
    private static final String JDK_PREFIX = "org.mule.tooling.jdk";
    public static final String JVM_PREF = "toolingClient.jvm";
    private final JVMHelper jvmHelper;

    public ToolingVMHelper() {
        this.jvmHelper = new JVMHelper();
    }

    public ToolingVMHelper(JVMHelper jvmHelper) {
        this.jvmHelper = jvmHelper;
    }

    public Optional<IVMInstall> getToolingDefaultVMInstall() {
        List vms = this.jvmHelper.getVMInstalls();
        Optional<IVMInstall> launchVmInstall = vms.stream().filter(this::isEmbedded).findAny().or(() -> vms.stream().filter(this::isRunning).findAny());
        return launchVmInstall;
    }

    public String getToolingVMJavaHome() {
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        String toolingJvm = preferenceStore.getString(JVM_PREF);
        Optional launchVmInstall = this.jvmHelper.getVMInstall(toolingJvm);
        String javaHome = launchVmInstall.or(() -> this.getToolingDefaultVMInstall()).flatMap(vmInstall -> Optional.ofNullable(vmInstall.getInstallLocation())).map(File::getAbsolutePath).orElseGet(() -> this.getJavaHomeProperty());
        return javaHome;
    }

    private boolean isEmbedded(IVMInstall vm) {
        String jdkBundle = "org.mule.tooling.jdk." + Platform.getOS();
        return vm.getInstallLocation() != null ? vm.getInstallLocation().getPath().contains(jdkBundle) : false;
    }

    private boolean isRunning(IVMInstall vm) {
        return vm.getInstallLocation() != null ? vm.getInstallLocation().getPath().equals(this.getJavaHomeProperty()) : false;
    }

    private String getJavaHomeProperty() {
        return System.getProperty("java.home");
    }

    protected String getOSArch() {
        return Platform.getOSArch();
    }

    /*
     * Exception decompiling
     */
    public String[][] getVMInstallsAsNameIDs() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getRunningVMName() {
        return System.getProperty("java.vendor.version", System.getProperty("java.vm.name")) + " (Running JVM)";
    }

    private /* synthetic */ String[] lambda$9() {
        return new String[]{this.getRunningVMName(), ""};
    }

    private static /* synthetic */ String[][] lambda$11(int n) {
        return new String[n][];
    }
}

