/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.ui.preferences;

import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.mule.tooling.client.Activator;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.client.utils.ToolingVMHelper;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.jvm.JVMHelper;
import org.mule.tooling.core.jvm.JdtJavaRuntimeResolver;
import org.mule.tooling.core.jvm.MuleRuntimeJavaCompatibilityComputer;
import org.mule.tooling.core.tooling.ToolingCachePathUtils;
import org.mule.tooling.core.utils.StudioFileUtils;
import org.mule.tooling.runtime.controller.MuleControllerException;
import org.osgi.framework.Version;

public class ToolingClientPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String STUDIO_SERVICE_NOT_RUNNING = "One or more Studio services are not running";
    private static final String STUDIO_SERVICE_IS_RUNNING = "Studio services are running";
    private static final String RESTARTING_TOOLING_MESSAGE = "Restarting Studio services";
    public static final String CONNECTION_TIMEOUT = "toolingClient.defaultConnectionTimeout";
    public static final String READ_TIMEOUT = "toolingClient.defaultReadTimeout";
    public static final String STARTUP_TIMEOUT = "toolingClient.defaultStartupTimeout";
    public static final String MAX_STARTUP_TIMEOUT = "toolingClient.maxStartupTimeout";
    public static final String MAX_RETRIES = "toolingClient.maxRetries";
    public static final String DYNAMIC_FLOW_REF = "metadataPropagation.flowReference";
    public static final String METADATA_PROPAGATION_ERROR = "Error";
    public static final String METADATA_PROPAGATION_WARNING = "Warning";
    public static final String METADATA_PROPAGATION_INFO = "Info";
    public static final String METADATA_PROPAGATION_IGNORE = "Ignore";
    public static final String MAX_ENTRIES_IN_MEMORY_IN_UNITS = "toolingClient.maxEntriesInMemory";
    public static final String OFF_HEAP_MB = "toolingClient.offHeapSizeInMB";
    public static final String DISK_MB = "toolingClient.diskSizeInMB";
    public static final String INIT_MEMORY = "toolingClient.initMemory";
    private Label statusLabel;

    public ToolingClientPreferencesPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getInstance().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Group configurationGroup = new Group(this.getFieldEditorParent(), 32);
        configurationGroup.setText("Configuration");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)configurationGroup);
        IntegerFieldEditor memoryEditor = new IntegerFieldEditor(INIT_MEMORY, "&Initial memory to be used by Studio services", (Composite)configurationGroup);
        memoryEditor.setValidRange(256, 1024);
        this.addField((FieldEditor)memoryEditor);
        IntegerFieldEditor maxRetriesField = new IntegerFieldEditor(MAX_RETRIES, "Max retries for starting Studio services", (Composite)configurationGroup);
        maxRetriesField.setValidRange(1, Integer.MAX_VALUE);
        this.addField((FieldEditor)maxRetriesField);
        Group timeoutGroup = new Group(this.getFieldEditorParent(), 32);
        timeoutGroup.setText("Timeouts configuration");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)timeoutGroup);
        IntegerFieldEditor connectionTimeoutField = new IntegerFieldEditor(CONNECTION_TIMEOUT, "Default Connection Timeout (ms)", (Composite)timeoutGroup);
        connectionTimeoutField.setValidRange(1, Integer.MAX_VALUE);
        this.addField((FieldEditor)connectionTimeoutField);
        IntegerFieldEditor readTimeoutField = new IntegerFieldEditor(READ_TIMEOUT, "Default Read Timeout (ms)", (Composite)timeoutGroup);
        readTimeoutField.setValidRange(1, Integer.MAX_VALUE);
        this.addField((FieldEditor)readTimeoutField);
        IntegerFieldEditor startupTimeoutField = new IntegerFieldEditor(STARTUP_TIMEOUT, "Default Startup Timeout (s)", (Composite)timeoutGroup);
        startupTimeoutField.setValidRange(1, this.getPreferenceStore().getInt(MAX_STARTUP_TIMEOUT));
        this.addField((FieldEditor)startupTimeoutField);
        Group lifeCycleGroup = new Group(this.getFieldEditorParent(), 32);
        lifeCycleGroup.setText("Life cycle");
        GridLayoutFactory.fillDefaults().applyTo((Composite)lifeCycleGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)lifeCycleGroup);
        ComboFieldEditor jvmField = new ComboFieldEditor("toolingClient.jvm", "Java VM for Studio services", new ToolingVMHelper().getVMInstallsAsNameIDs(), (Composite)lifeCycleGroup){

            protected void valueChanged(String oldValue, String newValue) {
                if (!Objects.equals(oldValue, newValue)) {
                    ToolingClientPreferencesPage.this.validateJVM(newValue);
                }
            }

            protected void refreshValidState() {
                ToolingClientPreferencesPage.this.validateJVM(this.getPreferenceStore().getString("toolingClient.jvm"));
            }
        };
        this.addField((FieldEditor)jvmField);
        PreferenceLinkArea jresLink = new PreferenceLinkArea((Composite)lifeCycleGroup, 0, "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", "See <a>''{0}''</a> to manage Java installations", (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridDataFactory.fillDefaults().span(2, 1).applyTo(jresLink.getControl());
        Composite composite = new Composite((Composite)lifeCycleGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)composite);
        Button statusButton = new Button(composite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)statusButton);
        statusButton.setText("Check status");
        Button restartButton = new Button(composite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)restartButton);
        restartButton.setText("Restart Studio services");
        this.statusLabel = new Label((Composite)lifeCycleGroup, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.statusLabel);
        statusButton.addSelectionListener((SelectionListener)new CheckStatusListener(this.statusLabel));
        restartButton.addSelectionListener((SelectionListener)new RestartListener(this.statusLabel));
        this.createUICacheSection();
        this.createMetadataStorageSection();
        this.createMetadataPropagationErrorsWarningsSection();
    }

    private void createUICacheSection() {
        Group editorsCache = new Group(this.getFieldEditorParent(), 32);
        editorsCache.setText("Modules Cache");
        Label description = new Label((Composite)editorsCache, 0);
        description.setText("This will erase all resources related to the modules.");
        Composite composite = new Composite((Composite)editorsCache, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        Button reset = new Button(composite, 0);
        reset.setText("Reset");
        reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean userAcceptsTerms = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Clearing Modules Cache", (String)"This action will automatically restart Anypoint Studio. The next startup will take longer as Studio needs to regenerate modules. Would you like to continue?");
                if (userAcceptsTerms) {
                    ToolingCachePathUtils.clearCaches();
                    StudioFileUtils.deleteDirectoriesFromTempDirectory((String)"extractedJar-");
                    PlatformUI.getWorkbench().restart();
                }
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)reset);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)description);
        GridLayoutFactory.fillDefaults().applyTo((Composite)editorsCache);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)editorsCache);
    }

    private void createMetadataStorageSection() {
        Group cacheGroup = new Group(this.getFieldEditorParent(), 32);
        cacheGroup.setText("Metadata Storage Cache");
        IntegerFieldEditor maxInMemoryEntries = new IntegerFieldEditor(MAX_ENTRIES_IN_MEMORY_IN_UNITS, "Max entries to keep in memory", (Composite)cacheGroup);
        maxInMemoryEntries.setValidRange(100, Integer.MAX_VALUE);
        this.addField((FieldEditor)maxInMemoryEntries);
        IntegerFieldEditor offHead = new IntegerFieldEditor(OFF_HEAP_MB, "Max Data in Memory (MB)", (Composite)cacheGroup);
        offHead.setValidRange(50, Integer.MAX_VALUE);
        this.addField((FieldEditor)offHead);
        IntegerFieldEditor disk = new IntegerFieldEditor(DISK_MB, "Max Data on Disk (MB)", (Composite)cacheGroup);
        disk.setValidRange(100, Integer.MAX_VALUE);
        this.addField((FieldEditor)disk);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)cacheGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)cacheGroup);
    }

    private void createMetadataPropagationErrorsWarningsSection() {
        Group errorWarningGroup = new Group(this.getFieldEditorParent(), 32);
        errorWarningGroup.setText("Metadata Propagation Errors/Warnings");
        String[][] namesAndValues = new String[4][2];
        namesAndValues[0][1] = METADATA_PROPAGATION_ERROR;
        namesAndValues[0][0] = METADATA_PROPAGATION_ERROR;
        namesAndValues[1][1] = METADATA_PROPAGATION_WARNING;
        namesAndValues[1][0] = METADATA_PROPAGATION_WARNING;
        namesAndValues[2][1] = METADATA_PROPAGATION_INFO;
        namesAndValues[2][0] = METADATA_PROPAGATION_INFO;
        namesAndValues[3][1] = METADATA_PROPAGATION_IGNORE;
        namesAndValues[3][0] = METADATA_PROPAGATION_IGNORE;
        ComboFieldEditor dynamicFlowRef = new ComboFieldEditor(DYNAMIC_FLOW_REF, "Dynamic Flow References", namesAndValues, (Composite)errorWarningGroup);
        dynamicFlowRef.setPreferenceStore(this.getPreferenceStore());
        dynamicFlowRef.load();
        this.addField((FieldEditor)dynamicFlowRef);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)errorWarningGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)errorWarningGroup);
    }

    protected void adjustGridLayout() {
        super.adjustGridLayout();
        ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 1;
    }

    public boolean performOk() {
        int initMemory = this.getPreferenceStore().getInt(INIT_MEMORY);
        int connectionTimeoutField = this.getPreferenceStore().getInt(CONNECTION_TIMEOUT);
        int readTimeoutField = this.getPreferenceStore().getInt(READ_TIMEOUT);
        int startupTimeoutField = this.getPreferenceStore().getInt(STARTUP_TIMEOUT);
        String initJVM = this.getPreferenceStore().getString("toolingClient.jvm");
        boolean result = super.performOk();
        int modifiedMemory = this.getPreferenceStore().getInt(INIT_MEMORY);
        String modifiedJVM = this.getPreferenceStore().getString("toolingClient.jvm");
        boolean timeoutChanged = false;
        timeoutChanged = this.sendTimeoutsConfigurationMetricsIfNecessary(connectionTimeoutField, this.getPreferenceStore().getInt(CONNECTION_TIMEOUT), CONNECTION_TIMEOUT);
        timeoutChanged = timeoutChanged || this.sendTimeoutsConfigurationMetricsIfNecessary(readTimeoutField, this.getPreferenceStore().getInt(READ_TIMEOUT), READ_TIMEOUT);
        boolean bl = timeoutChanged = timeoutChanged || this.sendTimeoutsConfigurationMetricsIfNecessary(startupTimeoutField, this.getPreferenceStore().getInt(STARTUP_TIMEOUT), STARTUP_TIMEOUT);
        if (timeoutChanged) {
            ToolingManager.getInstance().restartRetryCounter();
        }
        if (this.getPreferenceStore().getInt(OFF_HEAP_MB) >= this.getPreferenceStore().getInt(DISK_MB)) {
            this.setErrorMessage("Data in memory value has to be lower than data on disk");
            return false;
        }
        this.setErrorMessage(null);
        if (initMemory != modifiedMemory || !initJVM.equals(modifiedJVM)) {
            ToolingClientPreferencesPage.restartToolingInstance(this.statusLabel);
        }
        return result;
    }

    private boolean sendTimeoutsConfigurationMetricsIfNecessary(int oldValue, int newValue, String field) {
        if (oldValue != newValue) {
            AnalyticsRecordsFactory.single((String)Events.TOOLING_INSTANCE_TIMEOUTS_MODIFIED, (String[])new String[]{"field", field, "value", Integer.toString(newValue)}).track();
            return true;
        }
        return false;
    }

    private static void restartToolingInstance(final Label statusLabel) {
        statusLabel.setText(RESTARTING_TOOLING_MESSAGE);
        Job job = new Job(RESTARTING_TOOLING_MESSAGE){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ToolingManager.getInstance().restart();
                    Display.getDefault().asyncExec(() -> ToolingClientPreferencesPage.updateMessageLabel(statusLabel, label -> ToolingClientPreferencesPage.updateStatus(label)));
                }
                catch (MuleControllerException e) {
                    String message = "There was an error initializing tooling instance";
                    MuleCorePlugin.logError((String)message, (Throwable)e);
                    Display.getDefault().asyncExec(() -> ToolingClientPreferencesPage.updateMessageLabel(statusLabel, label -> label.setText(message)));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void validateJVM(String jvmId) {
        new JVMHelper().getVMInstall(jvmId).ifPresent(vmInstall -> {
            JdtJavaRuntimeResolver javaRuntimeResolver = new JdtJavaRuntimeResolver();
            Version configuredJavaVersion = Version.parseVersion((String)javaRuntimeResolver.getVersion(vmInstall));
            MuleRuntimeJavaCompatibilityComputer compatibilityComputer = MuleRuntimeJavaCompatibilityComputer.createReadingExtensions();
            if (!compatibilityComputer.isJavaVersionCompatible(ToolingManager.getLatestServerDefinition(), configuredJavaVersion).ifIncompatible((range, description) -> this.setMessage("Tooling instance requires " + description, 2))) {
                this.setMessage(null);
            }
        });
    }

    private static void updateStatus(Label label) {
        ToolingManager instance = ToolingManager.getInstance();
        boolean running = instance.isRunning();
        if (running) {
            label.setText(STUDIO_SERVICE_IS_RUNNING + instance.getInstanceDescription());
        } else {
            label.setText(STUDIO_SERVICE_NOT_RUNNING);
        }
    }

    private static void updateMessageLabel(Label messageLabel, UpdateMessage update) {
        if (messageLabel != null && !messageLabel.isDisposed()) {
            update.message(messageLabel);
        }
    }

    private static final class CheckStatusListener
    extends SelectionAdapter {
        private Label messageLabel;

        public CheckStatusListener(Label messageLabel) {
            this.messageLabel = messageLabel;
        }

        public void widgetSelected(SelectionEvent e) {
            AnalyticsRecordsFactory.single((String)Events.CHECK_TOOLING_INSTANCE_STATUS).track();
            this.messageLabel.setText("Checking Studio services status...");
            ToolingClientPreferencesPage.updateStatus(this.messageLabel);
        }
    }

    private static final class RestartListener
    extends SelectionAdapter {
        private Label messageLabel;

        public RestartListener(Label messageLabel) {
            this.messageLabel = messageLabel;
        }

        public void widgetSelected(SelectionEvent ev) {
            AnalyticsRecordsFactory.single((String)Events.RESTART_TOOLING_INSTANCE, (String[])new String[]{"from", "preference"}).track();
            ToolingClientPreferencesPage.restartToolingInstance(this.messageLabel);
        }
    }

    private static interface UpdateMessage {
        public void message(Label var1);
    }
}

