/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.startup;

import jakarta.inject.Inject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.client.Activator;
import org.mule.tooling.client.startup.ToolingNotAvailableException;
import org.mule.tooling.client.startup.ToolingServerDefinitionExtension;
import org.mule.tooling.client.utils.ToolingVMHelper;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IProxyConfigurationChangedListener;
import org.mule.tooling.core.event.ToolingInstanceStatusEvent;
import org.mule.tooling.core.io.CopyFileVisitor;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.runtime.controller.IMuleInstance;
import org.mule.tooling.runtime.controller.MuleController;
import org.mule.tooling.runtime.controller.MuleControllerException;
import org.mule.tooling.runtime.controller.MuleControllerHelper;
import org.mule.tooling.runtime.controller.MuleControllerManager;
import org.mule.tooling.runtime.controller.MuleInstanceConfiguration;
import org.mule.tooling.runtime.controller.MulePathHelper;
import org.mule.tooling.utils.collection.ListView;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.osgi.framework.Bundle;

public final class ToolingManager {
    private static final String THERE_WAS_AN_ERROR_INITIALIZING_TOOLING_CLIENT = "There was an error initializing tooling client";
    private static final String RESTARTING_MULE_TOOLING_CLIENT = "Restarting Mule Tooling Client";
    private static final String LOGS = "logs";
    private static final String TOOLING_PREFIX = "tooling-";
    public static final String TOOLING_METADATA = "TOOLING.txt";
    private static final String INVALID_INSTANCE = "Instance.invalid";
    private static final String VERSION_METADATA_ATTRIBUTE = "VERSION";
    public static final String VERSION_SUFFIX_METADATA_ATTRIBUTE = "VERSION.SUFFIX";
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String RUNTIMES_FOLDER = ".runtimes";
    private static final String EMBEDDED_MULE_INSTANCE = "mule";
    private static final String TOOLING_NEW_INSTANCE = "tooling.new.instance";
    private static final String TOOLING_SUFFIX_LENGTH = "tooling.suffix.length";
    private static final String TOOLING_SUFFIX_GENERATION = "tooling.suffix.max";
    private static final int DEFAULT_TOOLING_SUFFIX_LENGTH = 8;
    private static final int DEFAULT_MAX_PREFIX_GENERATION = 10;
    private static final int MAX_PREFIX_GENERATION = Integer.getInteger("tooling.suffix.max", 10);
    private static final List<String> ROOT_EXCLUDED_PATHS = Arrays.asList("apps", "apps-staging", "domains", "domains-staging", "Instance.lock", "logs");
    private volatile IMuleInstance toolingInstance;
    private MuleController controller;
    private AtomicInteger retryCounter = new AtomicInteger();
    private final EventBusHelper eventBusHelper = new EventBusHelper();
    private final Job restartToolingJob = new Job("Restarting Mule Tooling Client"){

        protected IStatus run(IProgressMonitor monitor) {
            monitor.subTask(ToolingManager.RESTARTING_MULE_TOOLING_CLIENT);
            try {
                try {
                    ToolingManager.this.restart();
                }
                catch (MuleControllerException e) {
                    MuleCorePlugin.logError((String)ToolingManager.THERE_WAS_AN_ERROR_INITIALIZING_TOOLING_CLIENT, (Throwable)e);
                    Status status = new Status(4, "org.mule.tooling.client", ToolingManager.THERE_WAS_AN_ERROR_INITIALIZING_TOOLING_CLIENT);
                    monitor.done();
                    return status;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    };

    @Inject
    public ToolingManager(EventBus eventBus) {
        this.eventBusHelper.registerListener(eventBus, CoreEventTypes.ON_PROXY_CONFIGURATION_CHANGED, (IEventHandler)((IProxyConfigurationChangedListener)this::restartUsingJob));
    }

    public static Optional<ToolingManager> retrieveIfActive() {
        if (!MuleCorePlugin.getContextValue(EventBus.class).isPresent()) {
            return Optional.empty();
        }
        return Optional.of(ToolingManager.getInstance());
    }

    public static ToolingManager getInstance() {
        return LazyHolder.instance;
    }

    public void restartRetryCounter() {
        this.retryCounter.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMuleInstance getToolingInstance() throws ToolingNotAvailableException {
        if (this.toolingInstance == null || this.toolingInstance != null && !this.isRunning()) {
            ToolingManager toolingManager = this;
            synchronized (toolingManager) {
                if (this.toolingInstance == null || this.toolingInstance != null && !this.isRunning()) {
                    this.setup();
                }
            }
        }
        return this.toolingInstance;
    }

    public void restartUsingJob() {
        this.restartToolingJob.schedule();
    }

    public void stop() {
        if (this.controller != null && this.isRunning()) {
            this.controller.stop();
        }
    }

    public void restart() {
        if (this.controller != null) {
            if (this.isRunning()) {
                this.controller.stop();
            }
            this.toolingInstance = this.controller.start(this.buildMuleInstanceConfiguration(this.getStartupTimeout(), ToolingManager.getLatestServerDefinition()));
            if (this.isRunning()) {
                this.restartRetryCounter();
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new ToolingInstanceStatusEvent());
            }
        }
    }

    public boolean isRunning() {
        return this.controller.isRunning();
    }

    public String getInstanceDescription() {
        return this.controller.isDebugMode() ? String.format(" (debugging at port: %s)", this.controller.getDebugPort()) : "";
    }

    private void setup() throws ToolingNotAvailableException {
        Path toolingPath = null;
        try {
            String version22;
            if (this.retryCounter.incrementAndGet() > this.getMaxRetries()) {
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new ToolingInstanceStatusEvent());
                String javaHome = this.getJavaHome();
                throw new ToolingNotAvailableException(String.format("Tooling instance is not available, Using Java home %s", javaHome));
            }
            IServerDefinition latestServerDefinition = ToolingManager.getLatestServerDefinition();
            int startupTimeout = this.getStartupTimeout();
            Bundle bundle = Platform.getBundle((String)"org.mule.tooling.client");
            File runtimesDirectory = bundle.getDataFile(RUNTIMES_FOLDER);
            if (!runtimesDirectory.exists() && !runtimesDirectory.mkdirs()) {
                Activator.debugTracer().trace(Activator.TOOLING_MANAGER_ID, MessageFormat.format("Tooling runtimes directory cannot be created", runtimesDirectory));
            }
            File[] runtimes = runtimesDirectory.listFiles();
            IPath latestPluginBaseDirectory = latestServerDefinition.getPluginBaseDirectory();
            Path mulePath = latestPluginBaseDirectory.toFile().toPath().resolve(EMBEDDED_MULE_INSTANCE);
            ArrayList<File> usableInstances = new ArrayList<File>();
            ArrayList<File> unusableInstances = new ArrayList<File>();
            ArrayList<String> toolingPrefixes = new ArrayList<String>();
            File[] fileArray = runtimes;
            int n = runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                File runtime = fileArray[n2];
                if (runtime.isDirectory() && runtime.getName().startsWith(TOOLING_PREFIX)) {
                    Properties properties = new Properties();
                    try {
                        Throwable throwable = null;
                        Object var18_26 = null;
                        try (FileReader metadata = new FileReader(new File(runtime, TOOLING_METADATA));){
                            boolean equalSuffix;
                            properties.load(metadata);
                            version22 = properties.getProperty(VERSION_METADATA_ATTRIBUTE);
                            String versionSuffix = properties.getProperty(VERSION_SUFFIX_METADATA_ATTRIBUTE);
                            String serverDefinitionSuffix = latestServerDefinition.getVersionSuffix();
                            boolean bl = equalSuffix = versionSuffix == null && serverDefinitionSuffix.isEmpty() || versionSuffix != null && serverDefinitionSuffix.equals(versionSuffix);
                            if (equalSuffix && latestServerDefinition.getVersion().equals(version22)) {
                                usableInstances.add(runtime);
                            } else {
                                unusableInstances.add(runtime);
                            }
                            toolingPrefixes.add(runtime.getName().substring(TOOLING_PREFIX.length()));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        unusableInstances.add(runtime);
                        Activator.debugTracer().trace(Activator.TOOLING_MANAGER_ID, MessageFormat.format("Metadata was not read from {0}", runtime));
                    }
                }
                ++n2;
            }
            for (File unusableInstance : unusableInstances) {
                if (FileUtils.deleteQuietly((File)unusableInstance)) continue;
                Activator.debugTracer().trace(Activator.TOOLING_MANAGER_ID, MessageFormat.format("Instance {0} was not deleted", unusableInstance));
                this.markInstanceAsInvalid(unusableInstance);
            }
            ArrayList<File> freeInstances = new ArrayList<File>();
            for (File toolingInstance : usableInstances) {
                File toolingLockInstanceFile = new File(toolingInstance, "Instance.lock");
                File toolingInvalidInstanceFile = new File(toolingInstance, INVALID_INSTANCE);
                if (toolingLockInstanceFile.exists() || toolingInvalidInstanceFile.exists()) continue;
                freeInstances.add(toolingInstance);
            }
            for (File toolingInstance : usableInstances) {
                if (freeInstances.contains(toolingInstance) || FileUtils.deleteQuietly((File)toolingInstance)) continue;
                Activator.debugTracer().trace(Activator.TOOLING_MANAGER_ID, MessageFormat.format("Instance {0} was not deleted", toolingInstance));
                this.markInstanceAsInvalid(toolingInstance);
            }
            int toolingPrefixLength = Integer.getInteger(TOOLING_SUFFIX_LENGTH, 8);
            boolean alwaysUseNewToolingInstance = Boolean.getBoolean(TOOLING_NEW_INSTANCE) || toolingPrefixLength == 0;
            String toolingPrefix = this.generateToolingPrefix(toolingPrefixLength);
            int iteration = 0;
            while (toolingPrefixes.contains(toolingPrefix) && !alwaysUseNewToolingInstance && iteration <= MAX_PREFIX_GENERATION) {
                ++iteration;
                toolingPrefix = this.generateToolingPrefix(toolingPrefixLength);
            }
            toolingPath = runtimesDirectory.toPath().resolve(TOOLING_PREFIX + toolingPrefix);
            MulePathHelper pathHelper = new MulePathHelper(toolingPath);
            if (freeInstances.isEmpty() || alwaysUseNewToolingInstance) {
                Serializable toolingLockFile;
                if (toolingPath.toFile().exists()) {
                    File toolingInstance = toolingPath.toFile();
                    toolingLockFile = new File(toolingInstance, "Instance.lock");
                    if (((File)toolingLockFile).exists()) {
                        Activator.debugTracer().trace(Activator.TOOLING_MANAGER_ID, "Waiting for deleting tooling instance");
                        TimeUnit.SECONDS.sleep(startupTimeout);
                    }
                    Activator.debugTracer().trace(Activator.TOOLING_MANAGER_ID, "Deleting tooling instance");
                    FileUtils.deleteDirectory((File)toolingInstance);
                }
                Activator.debugTracer().trace(Activator.TOOLING_MANAGER_ID, "Creating tooling instance");
                Files.createDirectory(toolingPath, new FileAttribute[0]);
                Properties properties = new Properties();
                properties.put(VERSION_METADATA_ATTRIBUTE, latestServerDefinition.getVersion());
                properties.put(VERSION_SUFFIX_METADATA_ATTRIBUTE, latestServerDefinition.getVersionSuffix());
                toolingLockFile = null;
                version22 = null;
                try (FileWriter writer = new FileWriter(new File(toolingPath.toFile(), TOOLING_METADATA));){
                    properties.store(writer, "");
                }
                catch (Throwable version22) {
                    if (toolingLockFile == null) {
                        toolingLockFile = version22;
                    } else if (toolingLockFile != version22) {
                        ((Throwable)toolingLockFile).addSuppressed(version22);
                    }
                    throw toolingLockFile;
                }
                ArrayList anchorAndPidFiles = new ArrayList();
                anchorAndPidFiles.addAll(pathHelper.getWrapperAnchorFile());
                anchorAndPidFiles.addAll(pathHelper.getMuleJavaPid());
                anchorAndPidFiles.addAll(pathHelper.getWrapperPid());
                List excludedPaths = ListView.of(ROOT_EXCLUDED_PATHS.stream().map(mulePath::resolve).collect(Collectors.toList()), anchorAndPidFiles);
                Activator.debugTracer().trace(Activator.TOOLING_MANAGER_ID, "Copying mule instance as tooling instance");
                Files.walkFileTree(mulePath, (FileVisitor<? super Path>)new CopyFileVisitor(toolingPath, excludedPaths));
            } else {
                Activator.debugTracer().trace(Activator.TOOLING_MANAGER_ID, "Reusing tooling instance");
                toolingPath = ((File)freeInstances.get(0)).toPath();
            }
            Activator.debugTracer().trace(Activator.TOOLING_MANAGER_ID, "Starting tooling instance");
            this.controller = MuleControllerManager.getInstance().get(toolingPath);
            this.toolingInstance = this.controller.start(this.buildMuleInstanceConfiguration(startupTimeout, latestServerDefinition));
            Runtime.getRuntime().addShutdownHook(new ToolingShutdownHook(this.controller));
            MuleCorePlugin.logInfo((String)String.format("Started tooling v[%s] with timeout [%ss] at path:%n%s", latestServerDefinition.getVersion(), startupTimeout, toolingPath));
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new ToolingInstanceStatusEvent());
            this.restartRetryCounter();
        }
        catch (IOException | InterruptedException | MuleControllerException e) {
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new ToolingInstanceStatusEvent());
            MuleCorePlugin.logError((String)"Error preparing tooling instance", (Throwable)e);
            this.markInstanceAsInvalid(toolingPath);
            throw new ToolingNotAvailableException("Tooling instance could not be started, another attempt will be made", e);
        }
    }

    public static IServerDefinition getLatestServerDefinition() {
        List toolingReadyServers = IExtensionPointReader.create(ToolingServerDefinitionExtension.class).readAll();
        if (toolingReadyServers.isEmpty() || !((ToolingServerDefinitionExtension)toolingReadyServers.get(0)).isEnterprise()) {
            throw new MuleControllerException("There are no servers available for tooling");
        }
        String serverId = ((ToolingServerDefinitionExtension)toolingReadyServers.get(0)).getServerId();
        IServerDefinition serverDefinition = MuleCorePlugin.getServerManager().getServerDefinition(serverId);
        if (serverDefinition == null) {
            throw new IllegalStateException("Latest tooling-ready runtime with id " + serverId + " could not be loaded");
        }
        return serverDefinition;
    }

    private void markInstanceAsInvalid(Path toolingPath) {
        if (toolingPath != null) {
            try {
                this.markInstanceAsInvalid(toolingPath.toFile());
            }
            catch (IOException e) {
                MuleCorePlugin.logError((String)"Error marking instance as invalid", (Throwable)e);
            }
        }
    }

    private void markInstanceAsInvalid(File toolingInstance) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter writer = new FileWriter(new File(toolingInstance, INVALID_INSTANCE));){
            writer.write("Invalid Instance");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private MuleInstanceConfiguration buildMuleInstanceConfiguration(int defaultStartupTimeout, IServerDefinition serverDefinition) {
        String javaHome = this.getJavaHome();
        return MuleInstanceConfiguration.newBuilder().withStartupTimeout(defaultStartupTimeout).withCheckExistingProcessTimeout(defaultStartupTimeout).withJavaHome(javaHome).withEnvironmentVariables(this.buildEnvironmentVariables(javaHome)).withVMArguments(MuleControllerHelper.getInitialVMArguments()).withDebugMode(Boolean.parseBoolean(System.getProperty("mule.tooling.debug", "false"))).withSuspendOnDebug(Boolean.parseBoolean(System.getProperty("mule.tooling.suspend", "false"))).withDebugPort(Integer.parseInt(System.getProperty("mule.toolingInstance.debugPort", Integer.toString(-1)))).withCrashReport(serverDefinition.getLabel(), serverDefinition.getDebuggerVersion()).isToolingInstance(true).build();
    }

    private String getJavaHome() {
        return new ToolingVMHelper().getToolingVMJavaHome();
    }

    private Map<String, String> buildEnvironmentVariables(String javaHome) {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put(JAVA_HOME, javaHome);
        return environmentVariables;
    }

    private int getStartupTimeout() {
        if (this.retryCounter.get() > 1) {
            return this.getStartupTimeoutForRetry();
        }
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        return preferenceStore.getInt("toolingClient.defaultStartupTimeout");
    }

    private int getStartupTimeoutForRetry() {
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        int retryTimeout = preferenceStore.getInt("toolingClient.defaultStartupTimeout") * 2;
        int maxTimeout = preferenceStore.getInt("toolingClient.maxStartupTimeout");
        return Math.min(retryTimeout, maxTimeout);
    }

    private int getMaxRetries() {
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        return preferenceStore.getInt("toolingClient.maxRetries");
    }

    private String generateToolingPrefix(int toolingPrefixLength) {
        return RandomStringUtils.randomAlphanumeric((int)toolingPrefixLength).toLowerCase();
    }

    private static class LazyHolder {
        private static final ToolingManager instance = (ToolingManager)EclipseContextHelper.createFromStudioContext(ToolingManager.class);

        private LazyHolder() {
        }
    }

    private static final class ToolingShutdownHook
    extends Thread {
        private MuleController controller;

        public ToolingShutdownHook(MuleController controller) {
            this.controller = controller;
        }

        @Override
        public void run() {
            this.controller.stop();
        }
    }
}

