/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.util.Iterator;
import java.util.List;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.client.metadata.MetadataFactory;

public final class TypeLabelProvider {
    private TypeLabelProvider() {
    }

    public static String getLabel(MetadataType metadataType) {
        StringBuilder labelBuilder = new StringBuilder();
        if (MetadataFactory.isUndefined(metadataType)) {
            labelBuilder.append("Unknown");
        } else {
            TypeMetadataTypeVisitor visitor = new TypeMetadataTypeVisitor();
            metadataType.accept((MetadataTypeVisitor)visitor);
            labelBuilder.append((CharSequence)visitor.getLabelBuilder());
        }
        return labelBuilder.toString();
    }

    private static class TypeMetadataTypeVisitor
    extends MetadataTypeVisitor {
        private final StringBuilder builder = new StringBuilder();

        private TypeMetadataTypeVisitor() {
        }

        public void visitAnyType(AnyType anyType) {
            this.builder.append("Any");
        }

        public StringBuilder getLabelBuilder() {
            return this.builder;
        }

        public void visitArrayType(ArrayType arrayType) {
            this.builder.append("Array<");
            arrayType.getType().accept((MetadataTypeVisitor)this);
            this.builder.append(">");
        }

        public void visitBinaryType(BinaryType binaryType) {
            this.builder.append("Binary");
        }

        public void visitBoolean(BooleanType booleanType) {
            this.builder.append("Boolean");
        }

        public void visitDateTime(DateTimeType dateTimeType) {
            this.builder.append("DateTime");
        }

        public void visitDate(DateType dateType) {
            this.builder.append("Date");
        }

        public void visitNothing(NothingType nothingType) {
            this.builder.append("Nothing");
        }

        public void visitNull(NullType nullType) {
            this.builder.append("Null");
        }

        public void visitVoid(VoidType voidType) {
            this.builder.append("Void");
        }

        public void visitNumber(NumberType numberType) {
            this.builder.append("Number");
        }

        public void visitObjectField(ObjectFieldType objectFieldType) {
            objectFieldType.getValue().accept((MetadataTypeVisitor)this);
            if (objectFieldType.isRepeated()) {
                this.builder.append("*");
            }
            if (!objectFieldType.isRequired()) {
                this.builder.append("?");
            }
        }

        public void visitAttributeField(AttributeFieldType attributeFieldType) {
            attributeFieldType.getValue().accept((MetadataTypeVisitor)this);
            if (!attributeFieldType.isRequired()) {
                this.builder.append("?");
            }
        }

        public void visitObject(ObjectType objectType) {
            this.builder.append("Object");
        }

        public void visitString(StringType stringType) {
            this.builder.append("String");
        }

        public void visitTime(TimeType timeType) {
            this.builder.append("Time");
        }

        public void visitTuple(TupleType tupleType) {
            this.builder.append("Tuple<");
            this.visitTypes(tupleType.getTypes());
            this.builder.append(">");
        }

        public void visitUnion(UnionType unionType) {
            this.builder.append("Union<");
            this.visitTypes(unionType.getTypes());
            this.builder.append(">");
        }

        public void visitIntersection(IntersectionType intersectionType) {
            this.builder.append("Intersection<");
            this.visitTypes(intersectionType.getTypes());
            this.builder.append(">");
        }

        private void visitTypes(List<MetadataType> types) {
            Iterator<MetadataType> iterator = types.iterator();
            while (iterator.hasNext()) {
                MetadataType type = iterator.next();
                type.accept((MetadataTypeVisitor)this);
                if (!iterator.hasNext()) continue;
                this.builder.append(", ");
            }
        }
    }
}

