/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.metadata.ComponentTracker;
import org.mule.tooling.model.messageflow.ComponentId;

public class TrackingCacheDecorator
implements MetadataCache,
ComponentTracker {
    private MetadataCache decorated;
    private List<ComponentId> modifiedComponents = new ArrayList<ComponentId>();

    public TrackingCacheDecorator(MetadataCache cache) {
        this.decorated = cache;
    }

    public Serializable getOperationMetadata(MetadataCache.MetadataCacheKeyInfo keyInfo, Callable<MetadataCache.MetadataResult> callable) {
        return this.decorated.getOperationMetadata(keyInfo, this.wrapCallable(keyInfo.getComponentId(), callable));
    }

    public Serializable getSourceMetadata(MetadataCache.MetadataCacheKeyInfo keyInfo, Callable<MetadataCache.MetadataResult> callable) {
        return this.decorated.getSourceMetadata(keyInfo, this.wrapCallable(keyInfo.getComponentId(), callable));
    }

    public Serializable getMetadataKeys(MetadataCache.MetadataCacheKeyInfo keyInfo, Callable<MetadataCache.MetadataResult> callable) {
        return this.decorated.getMetadataKeys(keyInfo, this.wrapCallable(keyInfo.getComponentId(), callable));
    }

    @Override
    public List<ComponentId> getComponents() {
        return this.modifiedComponents;
    }

    private Callable<MetadataCache.MetadataResult> wrapCallable(String componentId, Callable<MetadataCache.MetadataResult> callable) {
        return () -> {
            this.modifiedComponents.add(ComponentId.fromDocId((String)componentId));
            return (MetadataCache.MetadataResult)callable.call();
        };
    }
}

