/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Optional;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorage;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageFactory;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageFactoryContext;
import org.mule.tooling.client.metadata.InMemoryMetadataCacheStorage;
import org.mule.tooling.client.metadata.MetadataCacheStorageComponent;
import org.mule.tooling.client.metadata.MetadataCacheStorageFactoryContextAware;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;

public class ToolingMetadataCacheStorageFactory
implements MetadataCacheStorageFactory {
    public MetadataCacheStorage createMetadataCache(MetadataCacheStorageFactoryContext context) {
        Optional maybeMuleProjectFromToolingFolder = Optional.empty();
        try {
            context.getValueSerializer();
            maybeMuleProjectFromToolingFolder = ToolingWorkspace.getInstance().getMuleProjectFromToolingFolder(new File(context.getArtifactContentUrl().toURI()));
        }
        catch (URISyntaxException e) {
            MuleCorePlugin.logError((String)"Your artifact url is not a valid file", (Throwable)e);
        }
        return maybeMuleProjectFromToolingFolder.map(p -> {
            MetadataCacheStorageComponent projectComponent = (MetadataCacheStorageComponent)p.getProjectComponent(MetadataCacheStorageComponent.class);
            if (projectComponent instanceof MetadataCacheStorageFactoryContextAware) {
                MetadataCacheStorageComponent component = projectComponent;
                component.procressContext(context);
            }
            return projectComponent.getStorage();
        }).orElse(new InMemoryMetadataCacheStorage());
    }
}

