/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.util.Comparator;
import java.util.List;
import org.mule.tooling.client.metadata.IProjectMetadataManager;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public class ProjectMetadataExtensionManager {
    private final IProjectMetadataManager current = this.getIProjectMetadataManagers().stream().max(Comparator.comparing(ProjectMetadataManagerExtension::getPriority)).map(ProjectMetadataManagerExtension::getProjectMetadataManager).get();

    public static ProjectMetadataExtensionManager getInstance() {
        return Singleton.INSTANCE;
    }

    private ProjectMetadataExtensionManager() {
    }

    protected List<ProjectMetadataManagerExtension> getIProjectMetadataManagers() {
        return IExtensionPointReader.create(ProjectMetadataManagerExtension.class).readAll();
    }

    public IProjectMetadataManager getCurrentIProjectMetadataManager() {
        return this.current;
    }

    @ExtensionPoint(extensionPointId="org.mule.tooling.client.projectmetadatamanager")
    public static class ProjectMetadataManagerExtension {
        @ExtensionAttribute
        private int priority;
        @ExtensionAttribute(attributeName="class")
        private IProjectMetadataManager projectMetadataManager;

        public int getPriority() {
            return this.priority;
        }

        public IProjectMetadataManager getProjectMetadataManager() {
            return this.projectMetadataManager;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public void setProjectMetadataManager(IProjectMetadataManager projectMetadataManager) {
            this.projectMetadataManager = projectMetadataManager;
        }
    }

    private static class Singleton {
        private static final ProjectMetadataExtensionManager INSTANCE = new ProjectMetadataExtensionManager();

        private Singleton() {
        }
    }
}

