/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.ehcache.Cache;
import org.mule.tooling.client.Activator;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorage;

public class PersistentMetadataCacheStorage
implements MetadataCacheStorage {
    private final Cache<String, Object> cache;

    public PersistentMetadataCacheStorage(Cache<String, Object> cache) {
        this.cache = cache;
    }

    public Optional<Object> get(String key) {
        Object retrievedValue = this.cache.get((Object)key);
        if (retrievedValue != null) {
            return this.hit(key, retrievedValue);
        }
        return this.miss(key);
    }

    private <V> Optional<V> hit(String key, V value) {
        Activator.debugTracer().traceEntry(Activator.METADATA_STORAGE_CACHE_ID, (Object)key);
        Activator.debugTracer().traceDumpStack(Activator.METADATA_STORAGE_CACHE_TRACE_ID);
        return Optional.of(value);
    }

    private Optional<Object> miss(String key) {
        Activator.debugTracer().traceEntry(Activator.METADATA_STORAGE_CACHE_ID, (Object)key);
        Activator.debugTracer().traceDumpStack(Activator.METADATA_STORAGE_CACHE_TRACE_ID);
        return Optional.empty();
    }

    public Set<String> getAllKeys() {
        HashSet<String> keys = new HashSet<String>();
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            keys.add((String)((Cache.Entry)iterator.next()).getKey());
        }
        return keys;
    }

    public Object put(String key, Object value) {
        Activator.debugTracer().traceEntry(Activator.METADATA_STORAGE_CACHE_ID, (Object)key);
        Object oldValue = this.cache.get((Object)key);
        this.cache.put((Object)key, value);
        return oldValue;
    }

    public void remove(String ... keys) {
        Activator.debugTracer().traceEntry(Activator.METADATA_STORAGE_CACHE_ID, (Object[])keys);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            boolean removedObject = this.cache.containsKey((Object)key);
            this.cache.remove((Object)key);
            if (Activator.getInstance().isDebugging()) {
                if (removedObject) {
                    Activator.debugTracer().trace(Activator.METADATA_STORAGE_CACHE_ID, String.format("No entry found for key [%s]", key));
                } else {
                    Activator.debugTracer().trace(Activator.METADATA_STORAGE_CACHE_ID, String.format("Key removed [%s]", key));
                }
            }
            ++n2;
        }
    }
}

