/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;

public class MetadataTypeProxy
implements InvocationHandler {
    private static final String GET_ANNOTATION_METHOD = "getAnnotation";
    private static final Object GET_ANNOTATIONS_METHOD = "getAnnotations";
    private static final Method OBJECT_EQUALS = MetadataTypeProxy.getObjectMethod("equals", Object.class);
    private static final Method OBJECT_HASHCODE = MetadataTypeProxy.getObjectMethod("hashCode", new Class[0]);
    private MetadataType target;
    private Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations;

    private MetadataTypeProxy(MetadataType target, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
        this.target = target;
        this.annotations = annotations;
    }

    private MetadataType getTarget() {
        return this.target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (OBJECT_EQUALS.equals(method)) {
            return this.equalsInternal(proxy, args[0]);
        }
        if (OBJECT_HASHCODE == method) {
            return this.target.hashCode();
        }
        Object result = method.invoke((Object)this.target, args);
        if (GET_ANNOTATION_METHOD.equals(method.getName()) && this.annotations.containsKey(args[0])) {
            result = Optional.of(this.annotations.get(args[0]));
        } else if (GET_ANNOTATIONS_METHOD.equals(method.getName())) {
            LinkedHashSet<TypeAnnotation> annotationsSet = new LinkedHashSet<TypeAnnotation>();
            annotationsSet.addAll(this.annotations.values());
            annotationsSet.addAll(this.target.getAnnotations());
            result = annotationsSet;
        }
        return result;
    }

    private boolean equalsInternal(Object me, Object other) {
        if (other == null) {
            return false;
        }
        if (!Proxy.isProxyClass(other.getClass())) {
            return other.equals(this.target);
        }
        Optional<MetadataType> otherTarget = this.getTarget(other);
        return otherTarget.isPresent() ? otherTarget.get().equals(this.target) : false;
    }

    private Optional<MetadataType> getTarget(Object object) {
        InvocationHandler handler = Proxy.getInvocationHandler(object);
        if (!(handler instanceof MetadataTypeProxy)) {
            return Optional.empty();
        }
        return Optional.of(((MetadataTypeProxy)handler).target);
    }

    private static Method getObjectMethod(String name, Class<?> ... types) {
        try {
            return Object.class.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MetadataType proxying(MetadataType target, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
        Class<?> targetClass = target.getClass();
        return (MetadataType)Proxy.newProxyInstance(targetClass.getClassLoader(), targetClass.getInterfaces(), (InvocationHandler)new MetadataTypeProxy(target, annotations));
    }

    public static MetadataType unwrapIfProxy(MetadataType potentialProxy) {
        InvocationHandler invocationHandler;
        MetadataType unwrapped = potentialProxy;
        if (Proxy.isProxyClass(potentialProxy.getClass()) && (invocationHandler = Proxy.getInvocationHandler(unwrapped)) instanceof MetadataTypeProxy) {
            MetadataTypeProxy metadataTypeProxy = (MetadataTypeProxy)invocationHandler;
            unwrapped = metadataTypeProxy.getTarget();
        }
        return unwrapped;
    }
}

