/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.client.metadata.TypeLabelProvider;

public final class MetadataTypeHelper {
    public static final MetadataKey DEFAULT_OPERATION_TYPE_KEY = ToolingMetadataKeyBuilder.newKey("__default__").build();
    public static final String DEFAULT_TYPE_LABEL = "Default Type";
    private static final String ROOT_ELEMENT_MARK = "#root:";

    private MetadataTypeHelper() {
    }

    public static boolean isAssignable(MetadataType to, MetadataType from) {
        return to.getClass().isAssignableFrom(from.getClass()) && MetadataTypeHelper.compareTypeIdAnnotation(to, from);
    }

    private static boolean compareTypeIdAnnotation(MetadataType to, MetadataType from) {
        Optional annotationTo = to.getAnnotation(TypeIdAnnotation.class);
        Optional annotationFrom = from.getAnnotation(TypeIdAnnotation.class);
        return !annotationTo.isPresent() && !annotationFrom.isPresent() || annotationTo.map(type1 -> annotationFrom.isPresent() && type1.getValue().equals(((TypeIdAnnotation)annotationFrom.get()).getValue())).orElse(false) != false;
    }

    public static int hashCode(MetadataType metadataType) {
        MetadataType type = MetadataTypeProxy.unwrapIfProxy(metadataType);
        return System.identityHashCode(type);
    }

    public static String getName(MetadataType model) {
        if (model == null) {
            return MetadataTypeHelper.getName(MetadataFactory.undefined());
        }
        if (model.getMetadataFormat().equals((Object)MetadataFormat.JAVA) && model instanceof ObjectType) {
            String className = model.getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue).orElse("Pojo");
            return MetadataTypeHelper.getClassNameLabel(className);
        }
        if (model instanceof ArrayType) {
            return MetadataTypeHelper.getName(((ArrayType)model).getType()) + "s";
        }
        if (model.getMetadataFormat().equals((Object)MetadataFormat.XML) && model instanceof ObjectType) {
            Optional typeId = model.getAnnotation(TypeIdAnnotation.class);
            return typeId.map(value -> value.getValue().substring(value.getValue().indexOf("}") + 1)).orElse("Xml");
        }
        return MetadataTypeHelper.getLabel(model);
    }

    public static Map<String, String> getReaderProperties(MetadataType metadata) {
        Optional annotation = metadata.getAnnotation(MetadataFormatPropertiesAnnotation.class);
        return annotation.map(anno -> anno.getValue()).orElse(new HashMap());
    }

    public static String getId(MetadataType model) {
        if (model == null) {
            return MetadataTypeHelper.getId(MetadataFactory.undefined());
        }
        if ((model = MetadataTypeProxy.unwrapIfProxy(model)) instanceof SimpleType) {
            return model.getClass().getSimpleName().toLowerCase();
        }
        if (model.getMetadataFormat().equals((Object)MetadataFormat.JAVA) && model instanceof ObjectType) {
            return model.getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue).map(MetadataTypeHelper::getClassNameLabel).orElse("java");
        }
        if (model.getMetadataFormat().equals((Object)MetadataFormat.JSON) && model instanceof ObjectType) {
            return "json";
        }
        if (model.getMetadataFormat().equals((Object)MetadataFormat.XML) && model instanceof ObjectType) {
            ObjectFieldType rootType = (ObjectFieldType)((ObjectType)model).getFields().iterator().next();
            QName rootElement = rootType.getKey().getName();
            return rootElement != null ? rootElement.getLocalPart() : "xml";
        }
        if (model instanceof ArrayType) {
            return "list_" + MetadataTypeHelper.getId(((ArrayType)model).getType());
        }
        return model.getMetadataFormat().getId();
    }

    public static String getLabel(MetadataFormat metadataFormat) {
        return StringUtils.capitalize((String)metadataFormat.getLabel().orElse(metadataFormat.getId()));
    }

    public static String getTypeLabel(MetadataType metadataType) {
        return TypeLabelProvider.getLabel(metadataType);
    }

    public static Collection<AttributeFieldType> getAttributeFields(ObjectFieldType fieldType) {
        return fieldType.getKey().getAttributes();
    }

    public static String getDescription(MetadataType metadataType) {
        if (metadataType != null) {
            Optional description = metadataType.getAnnotation(DescriptionAnnotation.class);
            if (description.isPresent()) {
                return ((DescriptionAnnotation)description.get()).getValue();
            }
            Optional typeId = metadataType.getAnnotation(TypeIdAnnotation.class);
            if (typeId.isPresent()) {
                return ((TypeIdAnnotation)typeId.get()).getValue();
            }
        }
        return null;
    }

    public static String getFieldDescription(MetadataType fieldType) {
        Optional annotation = fieldType.getAnnotation(DescriptionAnnotation.class);
        return annotation.map(DescriptionAnnotation::getValue).orElse("");
    }

    public static String getFieldLabel(ObjectFieldType fieldType) {
        String fieldName = MetadataTypeHelper.getLabel((MetadataType)fieldType.getKey());
        String typeLabel = MetadataTypeHelper.getTypeLabel((MetadataType)fieldType);
        return MessageFormat.format("{0} : {1}", fieldName, typeLabel);
    }

    public static String getFieldLabel(AttributeFieldType attribute) {
        String fieldName = MetadataTypeHelper.getLabel((MetadataType)attribute);
        String typeLabel = MetadataTypeHelper.getTypeLabel((MetadataType)attribute);
        return MessageFormat.format("{0} : {1}", fieldName, typeLabel);
    }

    public static String getModelLabel(MetadataType metadataType) {
        final StringBuilder labelBuilder = new StringBuilder();
        metadataType = metadataType != null ? metadataType : MetadataFactory.undefined();
        metadataType.accept(new MetadataTypeVisitor(){

            public void visitAttributeField(AttributeFieldType attributeFieldType) {
                labelBuilder.append(MetadataTypeHelper.getLabel((MetadataType)attributeFieldType));
                labelBuilder.append(" : ");
                labelBuilder.append(MetadataTypeHelper.getTypeLabel((MetadataType)attributeFieldType));
            }

            public void visitObjectField(ObjectFieldType objectFieldType) {
                labelBuilder.append(MetadataTypeHelper.getLabel((MetadataType)objectFieldType.getKey()));
                labelBuilder.append(" : ");
                labelBuilder.append(MetadataTypeHelper.getTypeLabel((MetadataType)objectFieldType));
            }

            protected void defaultVisit(MetadataType metadataType) {
                labelBuilder.append(MetadataTypeHelper.getLabel(metadataType));
                labelBuilder.append(" : ");
                labelBuilder.append(MetadataTypeHelper.getTypeLabel(metadataType));
            }
        });
        return labelBuilder.toString();
    }

    public static String getLabel(MetadataType metadataType) {
        final StringBuilder builder = new StringBuilder();
        metadataType.accept(new MetadataTypeVisitor(){

            public void visitAttributeField(AttributeFieldType attributeFieldType) {
                builder.append("@" + attributeFieldType.getKey().getName().getLocalPart());
            }

            public void visitObjectKey(ObjectKeyType objectKeyType) {
                builder.append(objectKeyType.getName().getLocalPart());
                Optional maybeLabel = objectKeyType.getAnnotation(LabelAnnotation.class);
                if (maybeLabel.isPresent()) {
                    builder.append("(" + ((LabelAnnotation)maybeLabel.get()).getValue() + ")");
                }
            }

            public void visitObject(ObjectType objectType) {
                Optional maybeLabel = objectType.getAnnotation(LabelAnnotation.class);
                if (maybeLabel.isPresent()) {
                    builder.append(((LabelAnnotation)maybeLabel.get()).getValue());
                } else {
                    Optional maybeTypeIdAnnotation = objectType.getAnnotation(TypeIdAnnotation.class);
                    if (maybeTypeIdAnnotation.isPresent()) {
                        String id = ((TypeIdAnnotation)maybeTypeIdAnnotation.get()).getValue();
                        if (objectType.getMetadataFormat().equals((Object)MetadataFormat.XML)) {
                            if (id.startsWith(MetadataTypeHelper.ROOT_ELEMENT_MARK)) {
                                builder.append(String.format("Xml<%s>", QName.valueOf(id.substring(MetadataTypeHelper.ROOT_ELEMENT_MARK.length())).getLocalPart()));
                            } else {
                                builder.append(String.format("Xml<%s>", QName.valueOf(id).getLocalPart()));
                            }
                        } else {
                            builder.append(MetadataTypeHelper.getClassNameLabel(id));
                        }
                    } else {
                        builder.append(TypeLabelProvider.getLabel((MetadataType)objectType));
                    }
                }
            }

            protected void defaultVisit(MetadataType metadataType) {
                Optional maybeLabelAnnotation = metadataType.getAnnotation(LabelAnnotation.class);
                if (maybeLabelAnnotation.isPresent()) {
                    builder.append(((LabelAnnotation)maybeLabelAnnotation.get()).getValue());
                } else {
                    Optional maybeTypeIdAnnotation = metadataType.getAnnotation(TypeIdAnnotation.class);
                    if (maybeTypeIdAnnotation.isPresent()) {
                        builder.append(((TypeIdAnnotation)maybeTypeIdAnnotation.get()).getValue());
                    } else {
                        builder.append(TypeLabelProvider.getLabel(metadataType));
                    }
                }
            }
        });
        return builder.toString();
    }

    public static String getLabel(MetadataType metadataType, String id) {
        metadataType = metadataType != null ? metadataType : MetadataFactory.undefined();
        String metadataTypeName = MetadataTypeHelper.getTypeLabel(metadataType);
        String metadataTypeLabel = !DEFAULT_OPERATION_TYPE_KEY.equals(id) ? id : MetadataTypeHelper.getLabel(metadataType);
        return metadataTypeLabel + " : " + metadataTypeName;
    }

    public static QName toQName(AttributeFieldType field) {
        return field.getKey().getName();
    }

    public static QName toQName(ObjectFieldType field) {
        return field.getKey().getName();
    }

    public static MetadataType resolveModel(MetadataType metadataType) {
        if (metadataType instanceof ArrayType) {
            return MetadataTypeHelper.resolveModel(((ArrayType)metadataType).getType());
        }
        return metadataType;
    }

    private static String getClassNameLabel(String className) {
        String[] parts = className.split("\\.");
        return parts[parts.length - 1];
    }
}

