/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataMessage;

public final class MetadataFactory {
    private static final String UNDEFINED = "Undefined";
    public static final MetadataFormat ANY_METADATA_FORMAT = new MetadataFormat("*", "*", new String[]{"*/*"});
    private static final MetadataType UNDEFINED_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).anyType().id("Undefined").build();
    public static final MetadataType DATE_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).dateType().build();
    public static final MetadataType NULL_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).nullType().build();
    public static final MetadataType NUMBER_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).numberType().build();
    public static final MetadataType STRING_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).stringType().build();
    public static final MetadataType BOOLEAN_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).booleanType().build();
    public static final MetadataType DATETIME_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).dateTimeType().build();
    public static final MetadataType PAYLOAD_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).anyType().id("Payload").build();
    public static final MetadataType ATTRIBUTES_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).anyType().id("Attributes").build();
    public static final MetadataType ERROR_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).anyType().id("Error").build();
    public static final ObjectType VARIABLES_TYPE = new BaseTypeBuilder(ANY_METADATA_FORMAT).objectType().id("Variables").build();
    private static final Map<MetadataFormat, MetadataType> unknownTypes = new ConcurrentHashMap<MetadataFormat, MetadataType>();

    private MetadataFactory() {
    }

    public static MetadataEvent newEventWithPayload(MetadataType payload) {
        return new MetadataEvent(new MetadataMessage(payload, ATTRIBUTES_TYPE), ERROR_TYPE, VARIABLES_TYPE);
    }

    public static BaseTypeBuilder newBuilder() {
        return MetadataFactory.newBuilder(ANY_METADATA_FORMAT);
    }

    public static BaseTypeBuilder newBuilder(MetadataFormat format) {
        return new BaseTypeBuilder(format);
    }

    public static MetadataType undefined() {
        return UNDEFINED_TYPE;
    }

    public static boolean isUndefined(MetadataType metadataType) {
        return unknownTypes.containsKey(metadataType.getMetadataFormat()) && metadataType.getAnnotation(TypeIdAnnotation.class).map(id -> UNDEFINED.equals(id.getValue())).orElse(Boolean.FALSE) != false || UNDEFINED_TYPE == metadataType;
    }

    public static MetadataType newUndefined(MetadataFormat format) {
        return unknownTypes.computeIfAbsent(format, f -> new BaseTypeBuilder(f).anyType().id(UNDEFINED).build());
    }
}

