/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.util.Collection;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataMessage;
import org.mule.tooling.client.metadata.MetadataTypeHelper;

public final class MetadataEvent {
    public static final MetadataEvent UNKNOWN_EVENT = new MetadataEvent(new MetadataMessage(MetadataFactory.PAYLOAD_TYPE, MetadataFactory.ATTRIBUTES_TYPE), MetadataFactory.ERROR_TYPE, MetadataFactory.VARIABLES_TYPE);
    private final MetadataMessage message;
    private final MetadataType error;
    private final ObjectType variables;

    public MetadataEvent(MetadataMessage message, MetadataType error, ObjectType variables) {
        this.message = message;
        this.error = error;
        this.variables = variables;
    }

    public MetadataMessage getMessage() {
        return this.message;
    }

    public ObjectType getVariables() {
        return this.variables;
    }

    public MetadataType getPayload() {
        return this.message.getPayload();
    }

    public MetadataType getAttributes() {
        return this.message.getAttributes();
    }

    public MetadataType getError() {
        return this.error;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variablesHashCode(this.variables));
        return result;
    }

    private int variablesHashCode(ObjectType vars) {
        int result = 1;
        for (ObjectFieldType field : vars.getFields()) {
            String fieldName = field.getKey().getName().getLocalPart();
            result = 31 * result + (fieldName == null ? 0 : fieldName.hashCode());
            MetadataType value = field.getValue();
            result = 31 * result + (value == null ? 0 : MetadataTypeHelper.hashCode(value));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetadataEvent other = (MetadataEvent)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.error == null ? other.error != null : !this.error.equals(other.error)) {
            return false;
        }
        return !(this.variables == null ? other.variables != null : !this.variablesEquality(this.variables, other.variables));
    }

    private boolean variablesEquality(ObjectType vars, ObjectType otherVars) {
        Collection fields = vars.getFields();
        if (fields.size() != otherVars.getFields().size()) {
            return false;
        }
        for (ObjectFieldType field : fields) {
            String fieldName = field.getKey().getName().getLocalPart();
            Optional otherField = otherVars.getFieldByName(fieldName);
            if (otherField.isPresent()) {
                ObjectFieldType _otherField = (ObjectFieldType)otherField.get();
                if (MetadataTypeHelper.hashCode(field.getValue()) == MetadataTypeHelper.hashCode(_otherField.getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

