/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.ehcache.Cache;
import org.ehcache.PersistentUserManagedCache;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.ehcache.config.builders.UserManagedCacheConfiguration;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.impl.config.persistence.DefaultPersistenceConfiguration;
import org.ehcache.impl.config.persistence.UserManagedPersistenceContext;
import org.ehcache.impl.persistence.DefaultLocalPersistenceService;
import org.ehcache.spi.serialization.Serializer;
import org.mule.tooling.client.Activator;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorage;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageFactoryContext;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageSerializer;
import org.mule.tooling.client.metadata.MetadataCacheStorageFactoryContextAware;
import org.mule.tooling.client.metadata.PersistentMetadataCacheStorage;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectComponent;
import org.mule.tooling.utils.LazyValue;
import org.mule.tooling.utils.OsDetect;
import org.osgi.framework.Version;

public class MetadataCacheStorageComponent
implements IMuleProjectComponent,
MetadataCacheStorageFactoryContextAware {
    private static final String ERROR_CLOSING_CACHE = "Unexpected error closing cache";
    private static final String CACHE_NAME = "metadata-storage";
    private final IProject muleProject;
    private final LazyValue<MetadataCacheStorage> storage;
    private MetadataCacheStorageSerializer serializer;
    private final LocalPersistenceService persistenceService;
    private PersistentUserManagedCache<String, Object> userManagedCache;

    public MetadataCacheStorageComponent(IMuleProject muleProject) {
        this.muleProject = muleProject.getProject();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MetadataCacheStorageComponent.class.getClassLoader());
            this.storage = new LazyValue(this::getCache);
            this.persistenceService = new DefaultLocalPersistenceService(new DefaultPersistenceConfiguration(this.getCacheFolder().getRawLocation().toFile()));
            this.userManagedCache = this.initUserManagedCache();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private PersistentMetadataCacheStorage getCache() {
        return new PersistentMetadataCacheStorage((Cache<String, Object>)this.userManagedCache);
    }

    private PersistentUserManagedCache<String, Object> initUserManagedCache() {
        PersistentUserManagedCache cache = (PersistentUserManagedCache)UserManagedCacheBuilder.newUserManagedCacheBuilder(String.class, Object.class).with((UserManagedCacheConfiguration)new UserManagedPersistenceContext(CACHE_NAME, this.persistenceService)).withResourcePools(this.getResourcePoolsBuilder()).withValueSerializer(this.getValueSerializer()).build(true);
        return cache;
    }

    private Serializer<Object> getValueSerializer() {
        return new Serializer<Object>(){

            public ByteBuffer serialize(Object object) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (ByteArrayOutputStream bstream = new ByteArrayOutputStream();){
                        MetadataCacheStorageComponent.this.serializer.serialize((OutputStream)bstream, object);
                        ByteBuffer buffer = ByteBuffer.allocate(bstream.size());
                        byte[] byteArray = bstream.toByteArray();
                        if (Activator.getInstance().isDebugging()) {
                            Activator.debugTracer().trace(Activator.METADATA_STORAGE_CACHE_ID, "Writing to buffer value:\n" + new String(byteArray));
                        }
                        buffer.put(byteArray);
                        buffer.flip();
                        return buffer;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    MuleCorePlugin.logErrorAndShowErrorSense((String)"Unexpected error writing content to cache.", (Throwable)e);
                    return null;
                }
            }

            public Object read(ByteBuffer byteBuffer) throws ClassNotFoundException {
                byte[] array = byteBuffer.array();
                if (Activator.getInstance().isDebugging()) {
                    Activator.debugTracer().trace(Activator.METADATA_STORAGE_CACHE_ID, "Reading frombuffer value:\n" + new String(array));
                }
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (ByteArrayInputStream byteBufferIS = new ByteArrayInputStream(array);){
                        return MetadataCacheStorageComponent.this.serializer.deserialize((InputStream)byteBufferIS);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    MuleCorePlugin.logErrorAndShowErrorSense((String)"Unexpected error reading content from cache.", (Throwable)ex);
                    return null;
                }
            }

            public boolean equals(Object o, ByteBuffer byteBuffer) throws ClassNotFoundException {
                return this.serialize(o).equals(byteBuffer);
            }
        };
    }

    private ResourcePoolsBuilder getResourcePoolsBuilder() {
        return ResourcePoolsBuilder.heap((long)this.getMaxEntriesInMemoryUnitsSize()).offheap((long)this.getOffHeadpInMegas(), MemoryUnit.MB).disk((long)this.getDiskInMegas(), MemoryUnit.MB, true);
    }

    private int getMaxEntriesInMemoryUnitsSize() {
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        return preferenceStore.getInt("toolingClient.maxEntriesInMemory");
    }

    private int getOffHeadpInMegas() {
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        return preferenceStore.getInt("toolingClient.offHeapSizeInMB");
    }

    private int getDiskInMegas() {
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        return preferenceStore.getInt("toolingClient.diskSizeInMB");
    }

    public MetadataCacheStorage getStorage() {
        return (MetadataCacheStorage)this.storage.getOrCompute();
    }

    public void init() {
    }

    private IFile getCacheFolder() {
        return this.muleProject.getFolder(".mule").getFolder(MetadataCacheStorageComponent.getVersion()).getFile("cache");
    }

    private static String getVersion() {
        Version pluginVersion = MuleCorePlugin.getContext().getBundle().getVersion();
        Version versionForPath = new Version(pluginVersion.getMajor(), pluginVersion.getMinor(), pluginVersion.getMicro());
        return versionForPath.toString();
    }

    public void stop() {
        block12: {
            try {
                try {
                    this.userManagedCache.close();
                }
                catch (Exception ex) {
                    MuleCorePlugin.logError((String)ERROR_CLOSING_CACHE, (Throwable)ex);
                    this.persistenceService.stop();
                    if (!OsDetect.isWindows()) break block12;
                    System.gc();
                    System.runFinalization();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ex2) {
                        MuleCorePlugin.logError((String)ERROR_CLOSING_CACHE, (Throwable)ex2);
                    }
                }
            }
            finally {
                this.persistenceService.stop();
                if (OsDetect.isWindows()) {
                    System.gc();
                    System.runFinalization();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ex) {
                        MuleCorePlugin.logError((String)ERROR_CLOSING_CACHE, (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public void procressContext(MetadataCacheStorageFactoryContext context) {
        this.serializer = context.getValueSerializer();
    }
}

