/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.tooling.client.Activator;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorage;

public class InMemoryMetadataCacheStorage
implements MetadataCacheStorage {
    private final Map<String, Object> cache = new LinkedHashMap<String, Object>();

    public Optional<Object> get(String key) {
        Object retrievedValue = this.cache.get(key);
        if (retrievedValue != null) {
            return this.hit(key, retrievedValue);
        }
        return this.miss(key);
    }

    private <V> Optional<V> hit(String key, V value) {
        Activator.debugTracer().traceEntry(Activator.METADATA_STORAGE_CACHE_ID, (Object)key);
        Activator.debugTracer().traceDumpStack(Activator.METADATA_STORAGE_CACHE_TRACE_ID);
        return Optional.of(value);
    }

    private Optional<Object> miss(String key) {
        Activator.debugTracer().traceEntry(Activator.METADATA_STORAGE_CACHE_ID, (Object)key);
        Activator.debugTracer().traceDumpStack(Activator.METADATA_STORAGE_CACHE_TRACE_ID);
        return Optional.empty();
    }

    public Set<String> getAllKeys() {
        return this.cache.keySet();
    }

    public Object put(String key, Object value) {
        Activator.debugTracer().traceEntry(Activator.METADATA_STORAGE_CACHE_ID, (Object)key);
        return this.cache.put(key, value);
    }

    public void remove(String ... keys) {
        Activator.debugTracer().traceEntry(Activator.METADATA_STORAGE_CACHE_ID, (Object[])keys);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Object removedObject = this.cache.remove(key);
            if (Activator.getInstance().isDebugging()) {
                if (removedObject == null) {
                    Activator.debugTracer().trace(Activator.METADATA_STORAGE_CACHE_ID, String.format("No entry found for key [%s]", key));
                } else {
                    Activator.debugTracer().trace(Activator.METADATA_STORAGE_CACHE_ID, String.format("Key removed [%s]", key));
                }
            }
            ++n2;
        }
    }
}

