/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.client.api.introspection.IntrospectionMulePlugin;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.ui.utils.UiUtils;

public class JavaCompatibilityServiceHandler
extends AbstractHandler {
    private static final String JAVA_COMPATIBILITY_MARKER = "org.mule.tooling.client.java17Compatibility";

    public boolean isEnabled() {
        IMuleProject muleProject = UiUtils.getSelectedMuleProjectInPackageExplorer();
        return muleProject != null && MuleProjectKind.APPLICATION.classifies(muleProject);
    }

    /*
     * Exception decompiling
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private WorkspaceJob refreshJavaCompatibilityMarkersJob(final IFile pomFile, final IMarker[] markersToDelete, final List<Map.Entry<String, IntrospectionMulePlugin>> java17IncompatibleComponents) {
        return new WorkspaceJob("Refresh Java compatibility markers"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                JavaCompatibilityServiceHandler.this.deleteExistingMarkers(markersToDelete);
                if (!java17IncompatibleComponents.isEmpty()) {
                    java17IncompatibleComponents.stream().forEach(entry -> {
                        try {
                            JavaCompatibilityServiceHandler.createJavaIncompatibilityMarker(pomFile, entry);
                        }
                        catch (CoreException e) {
                            MuleCorePlugin.logError((String)("Error when creating marker for resource " + String.valueOf(pomFile)), (Throwable)e);
                        }
                    });
                } else {
                    try {
                        JavaCompatibilityServiceHandler.createAllJavaCompatibleMarker(pomFile);
                    }
                    catch (CoreException e) {
                        MuleCorePlugin.logError((String)("Error when creating marker for resource " + String.valueOf(pomFile)), (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
    }

    private WorkspaceJob failedIntrospectionErrorMarkersJob(final IFile pomFile, final IMarker[] markersToDelete) {
        return new WorkspaceJob("Refresh Java compatibility markers"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                JavaCompatibilityServiceHandler.this.deleteExistingMarkers(markersToDelete);
                JavaCompatibilityServiceHandler.createIntrospectionErrorMarker(pomFile);
                return Status.OK_STATUS;
            }
        };
    }

    private void deleteExistingMarkers(IMarker[] oldMarkers) {
        Arrays.stream(oldMarkers).forEach(marker -> {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("Error when deleting marker for resource " + String.valueOf(marker.getResource())), (Throwable)e);
            }
        });
    }

    private static IMarker createJavaIncompatibilityMarker(IFile pomFile, Map.Entry<String, IntrospectionMulePlugin> entry) throws CoreException {
        return JavaCompatibilityServiceHandler.createMarker(pomFile, 0, String.format("%s Module version %s is not Java 17 compatible. Supported Java versions are: %s.", entry.getKey(), entry.getValue().getSemverVersion(), entry.getValue().getSupportedJavaVersions().toString().replace("[", "").replace("]", "")));
    }

    private static IMarker createIntrospectionErrorMarker(IFile pomFile) throws CoreException {
        return JavaCompatibilityServiceHandler.createMarker(pomFile, 0, "Java 17 Module Compatibility check failed. See the error log for more information.");
    }

    private static IMarker createAllJavaCompatibleMarker(IFile pomFile) throws CoreException {
        return JavaCompatibilityServiceHandler.createMarker(pomFile, 0, "Java 17 Module Compatibility check completed. All modules are Java 17 compatible.");
    }

    private static IMarker createMarker(IFile pomFile, int severity, String message) throws CoreException {
        IMarker marker = pomFile.createMarker(JAVA_COMPATIBILITY_MARKER);
        marker.setAttribute("severity", severity);
        marker.setAttribute("lineNumber", 1);
        marker.setAttribute("message", (Object)message);
        return marker;
    }

    private static /* synthetic */ boolean lambda$0(Map.Entry e) {
        return !((IntrospectionMulePlugin)e.getValue()).getSupportedJavaVersions().contains("17");
    }
}

