/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.client.ToolingClientFactory;
import org.mule.tooling.client.api.ToolingApplication;
import org.mule.tooling.client.api.ToolingClient;
import org.mule.tooling.client.api.introspection.IntrospectionAPIResponse;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.runtime.controller.IMuleInstance;
import org.mule.tooling.runtime.tooling.ToolingProject;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;
import org.mule.tooling.ui.project.FlowCountDialog;
import org.mule.tooling.ui.utils.UiUtils;

public class BillableFlowsServiceHandler
extends AbstractHandler {
    public boolean isEnabled() {
        return UiUtils.getSelectedMuleProjectInPackageExplorer() != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMuleProject muleProject = UiUtils.getSelectedMuleProjectInPackageExplorer();
        ToolingWorkspace workspace = ToolingWorkspace.getInstance();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ToolingProject toolingProject = workspace.install(muleProject);){
                IMuleInstance instance = ToolingManager.getInstance().getToolingInstance();
                ToolingClient toolingClient = ToolingClientFactory.buildToolingClient(instance, muleProject);
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (ToolingApplication toolingApplication = toolingClient.newToolingApplication(toolingProject);){
                    IntrospectionAPIResponse response = toolingApplication.getIntrospectionService().getBillableFlows();
                    new FlowCountDialog(Display.getCurrent().getActiveShell(), response.getFlows(), muleProject.getName()).open();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error while trying to resolve billable flows", (Throwable)e);
        }
        return null;
    }
}

