/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api;

import java.io.IOException;
import java.util.Optional;
import org.mule.tooling.client.ToolingClientFactory;
import org.mule.tooling.client.api.ResourceLoader;
import org.mule.tooling.client.api.ToolingApplication;
import org.mule.tooling.client.api.ToolingClient;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.runtime.controller.IMuleInstance;
import org.mule.tooling.runtime.tooling.ToolingProject;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;

public class ToolingResourceLoader
implements AutoCloseable {
    private ToolingApplication application;
    private Optional<ResourceLoader> resourceLoader;

    private ToolingResourceLoader() {
    }

    private static ToolingResourceLoader instance(ToolingApplication application, Optional<ResourceLoader> resourceLoader) {
        ToolingResourceLoader result = new ToolingResourceLoader();
        result.application = application;
        result.resourceLoader = resourceLoader;
        return result;
    }

    public boolean isPresent() {
        return this.resourceLoader.isPresent();
    }

    public Optional<ResourceLoader> get() {
        return this.resourceLoader;
    }

    @Override
    public void close() throws IOException {
        this.application.close();
    }

    public static ToolingResourceLoader fromProject(IMuleProject muleProject) throws Exception {
        ToolingWorkspace toolingWorkspace = ToolingWorkspace.getInstance();
        ToolingProject toolingProject = toolingWorkspace.install(muleProject);
        IMuleInstance instance = ToolingManager.getInstance().getToolingInstance();
        ToolingClient toolingClient = ToolingClientFactory.buildToolingClient(instance, toolingProject.getProject());
        ToolingApplication toolingApplication = toolingClient.newToolingApplication(toolingProject);
        Optional<ResourceLoader> resourceLoader = toolingApplication.getResourceLoader();
        return ToolingResourceLoader.instance(toolingApplication, resourceLoader);
    }
}

