/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.mule.tooling.client.api.DataWeaveExecutionError;

public class KeyValuePairsResult {
    private final Optional<Map<String, String>> keyValuePairs;
    private final Optional<List<DataWeaveExecutionError>> errorMessages;

    public static KeyValuePairsResult fromErrors(List<DataWeaveExecutionError> errorMessages) {
        return new KeyValuePairsResult(Optional.empty(), Optional.of(errorMessages));
    }

    public static KeyValuePairsResult fromKeyValuePairs(Map<String, String> keyValuePairs) {
        return new KeyValuePairsResult(Optional.of(keyValuePairs), Optional.empty());
    }

    private KeyValuePairsResult(Optional<Map<String, String>> keyValuePairs, Optional<List<DataWeaveExecutionError>> errorMessages) {
        Objects.requireNonNull(keyValuePairs, "keyValuePairs cannot be null");
        Objects.requireNonNull(errorMessages, "errorMessages cannot be null");
        this.keyValuePairs = keyValuePairs;
        this.errorMessages = errorMessages;
    }

    public boolean isSuccess() {
        return !this.errorMessages.isPresent();
    }

    public Optional<Map<String, String>> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public Optional<List<String>> getErrorMessages() {
        return this.errorMessages.map(errorMessages -> {
            ArrayList messages = new ArrayList();
            errorMessages.forEach(d -> d.getMessage().ifPresent(message -> messages.add(message)));
            return messages;
        });
    }
}

