/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.agent.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.tooling.client.api.ToolingSerializationService;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService;
import org.mule.tooling.client.api.artifact.declaration.request.XmlArtifactDeserializationRequest;
import org.mule.tooling.client.api.artifact.declaration.request.XmlArtifactSerializationRequest;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;

public class ToolingClientSerializationService
implements ToolingSerializationService {
    private ArtifactSerializationService artifactSerializationService;

    public ToolingClientSerializationService(ArtifactSerializationService artifactSerializationService) {
        this.artifactSerializationService = artifactSerializationService;
    }

    @Override
    public String serializeMuleConfiguration(IMuleProject muleProject, ArtifactDeclaration artifactDeclaration) {
        List<ArtifactDescriptor> pluginDependencies = this.getPluginDependencies(muleProject);
        XmlArtifactSerializationRequest serializationRequest = new XmlArtifactSerializationRequest(artifactDeclaration, pluginDependencies);
        return this.artifactSerializationService.toXml(serializationRequest);
    }

    @Override
    public ArtifactDeclaration loadMuleConfiguration(IMuleProject muleProject, IFile configurationFile) throws IOException, CoreException {
        InputStream stream = configurationFile.getContents();
        try {
            List<ArtifactDescriptor> pluginDependencies = this.getPluginDependencies(muleProject);
            XmlArtifactDeserializationRequest deserializationRequest = new XmlArtifactDeserializationRequest(stream, pluginDependencies);
            ArtifactDeclaration artifactDeclaration = this.artifactSerializationService.fromXml(deserializationRequest);
            return artifactDeclaration;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    private List<ArtifactDescriptor> getPluginDependencies(IMuleProject muleProject) {
        return muleProject.getDeclaredExtensions().stream().map(MavenUtils::getDependency).map(dependency -> ArtifactDescriptor.newBuilder().withGroupId(dependency.getGroupId()).withArtifactId(dependency.getArtifactId()).withVersion(dependency.getVersion()).withClassifier((String)dependency.getClassifier().orElseThrow(() -> new IllegalArgumentException(dependency.toString()))).build()).collect(Collectors.toList());
    }
}

