/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.agent.impl;

import java.util.Optional;
import java.util.Set;
import org.mule.tooling.client.api.ServiceResponse;
import org.mule.tooling.client.api.ServiceResponseFactory;
import org.mule.tooling.client.api.ValueProviderExecutionRequest;
import org.mule.tooling.client.api.ValueProviderToolingService;
import org.mule.tooling.client.api.value.ResolvingFailure;
import org.mule.tooling.client.api.value.Value;
import org.mule.tooling.client.api.value.ValueResult;
import org.mule.tooling.client.api.value.provider.ValueProviderRequest;
import org.mule.tooling.client.api.value.provider.ValueProviderService;

public class DefaultValueProviderToolingService
implements ValueProviderToolingService {
    private final ValueProviderService valueProviderService;

    public DefaultValueProviderToolingService(ValueProviderService valueProviderService) {
        this.valueProviderService = valueProviderService;
    }

    @Override
    public ServiceResponse<Set<Value>> retrieveValues(ValueProviderExecutionRequest request) {
        ValueProviderRequest valueProviderRequest = new ValueProviderRequest();
        valueProviderRequest.setLocation(request.getLocation());
        valueProviderRequest.setProviderName(request.getProviderName());
        valueProviderRequest.setRequestTimeout(request.getTimeout());
        ValueResult valueProviderResult = this.valueProviderService.getValues(valueProviderRequest);
        if (valueProviderResult.isSuccess()) {
            return ServiceResponseFactory.from(valueProviderResult.isSuccess(), "", "", valueProviderResult.getValues());
        }
        Optional failure = valueProviderResult.getFailure();
        if (failure.isPresent()) {
            ResolvingFailure resolvingFailure = (ResolvingFailure)failure.get();
            return ServiceResponseFactory.from(valueProviderResult.isSuccess(), resolvingFailure.getMessage(), resolvingFailure.getReason(), valueProviderResult.getValues());
        }
        return ServiceResponseFactory.from(valueProviderResult.isSuccess(), "Unexpected error", "UNKNOWN", valueProviderResult.getValues());
    }
}

