/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.agent.impl;

import java.io.IOException;
import java.util.Optional;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.client.agent.impl.DefaultAgentConnectionToolingService;
import org.mule.tooling.client.agent.impl.DefaultAgentDataSenseToolingService;
import org.mule.tooling.client.agent.impl.DefaultAgentDataWeaveExecutionService;
import org.mule.tooling.client.agent.impl.DefaultAgentMetadataToolingService;
import org.mule.tooling.client.agent.impl.DefaultIntrospectionToolingService;
import org.mule.tooling.client.agent.impl.DefaultResourceLoader;
import org.mule.tooling.client.agent.impl.DefaultValueProviderToolingService;
import org.mule.tooling.client.api.ConnectionToolingService;
import org.mule.tooling.client.api.DataSenseToolingService;
import org.mule.tooling.client.api.DataWeaveExecutionService;
import org.mule.tooling.client.api.IntrospectionToolingService;
import org.mule.tooling.client.api.MetadataToolingService;
import org.mule.tooling.client.api.ResourceLoader;
import org.mule.tooling.client.api.ToolingApplication;
import org.mule.tooling.client.api.ValueProviderToolingService;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.ToolingJobsManager;

public class DefaultAgentMuleApplication
implements ToolingApplication {
    private ToolingArtifact toolingArtifact;

    public DefaultAgentMuleApplication(ToolingArtifact toolingArtifact) {
        this.toolingArtifact = toolingArtifact;
    }

    @Override
    public MetadataToolingService getMetadataToolingService() {
        return new DefaultAgentMetadataToolingService(this.toolingArtifact.metadataService());
    }

    @Override
    public DataSenseToolingService getDataSenseToolingService() {
        return new DefaultAgentDataSenseToolingService(this.toolingArtifact.dataSenseService());
    }

    @Override
    public ConnectionToolingService getConnectionToolingService() {
        return new DefaultAgentConnectionToolingService(this.toolingArtifact.connectivityTestingService());
    }

    @Override
    public DataWeaveExecutionService getDataWeaveExecutionService() {
        return new DefaultAgentDataWeaveExecutionService(this.toolingArtifact.dataWeaveService());
    }

    @Override
    public ValueProviderToolingService getValueProviderToolingService() {
        return new DefaultValueProviderToolingService(this.toolingArtifact.valueProviderService());
    }

    @Override
    public void close() throws IOException {
        Job job = Job.create((String)"Disposing tooling artifact", monitor -> {
            try {
                try {
                    this.toolingArtifact.dispose();
                }
                catch (Exception ex) {
                    MuleCorePlugin.logError((String)"Unexpected error disposing tooling artifact", (Throwable)ex);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        });
        job.setJobGroup(ToolingJobsManager.getDisposeJobGroup());
        job.schedule();
    }

    @Override
    public Optional<ResourceLoader> getResourceLoader() {
        return this.toolingArtifact.getResourceLoader().isEnabled() ? Optional.of(new DefaultResourceLoader((org.mule.tooling.client.api.artifact.resources.ResourceLoader)this.toolingArtifact.getResourceLoader().get())) : Optional.empty();
    }

    @Override
    public IntrospectionToolingService getIntrospectionService() {
        return new DefaultIntrospectionToolingService(this.toolingArtifact.introspectionService());
    }
}

