/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.agent.impl;

import org.mule.tooling.client.api.MetadataToolingService;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.metadata.MetadataKeysContainer;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.client.api.metadata.MetadataService;

public class DefaultAgentMetadataToolingService
implements MetadataToolingService {
    private MetadataService metadataService;

    public DefaultAgentMetadataToolingService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(String componentPath) {
        MetadataKeysRequest request = new MetadataKeysRequest();
        Location location = Location.builderFromStringRepresentation((String)componentPath).build();
        request.setLocation(location);
        long start = System.currentTimeMillis();
        MetadataResult metadataResult = this.metadataService.getMetadataKeys(request);
        System.out.println("Metadata Keys: " + (System.currentTimeMillis() - start));
        return metadataResult;
    }

    @Override
    public void evictMetadataAt(String componentPath) {
        this.metadataService.disposeMetadataCache().ifEnabled(evictKeysAction -> {
            Location location = Location.builderFromStringRepresentation((String)componentPath).build();
            evictKeysAction.perform((Object)location);
        });
    }

    @Override
    public void evictMetadataKeysAt(String componentPath) {
        this.metadataService.invalidateMetadataCacheKeys().ifEnabled(evictKeysAction -> {
            Location location = Location.builderFromStringRepresentation((String)componentPath).build();
            evictKeysAction.perform((Object)location);
        });
    }
}

