/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.agent.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.tooling.client.ToolingDataWeaveExecutionError;
import org.mule.tooling.client.api.DataWeaveExecutionError;
import org.mule.tooling.client.api.DataWeaveExecutionResponse;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewResponse;
import org.mule.tooling.client.api.el.Location;
import org.mule.tooling.client.api.el.Position;
import org.mule.tooling.client.api.el.Severity;
import org.mule.tooling.client.api.el.ValidationMessage;
import org.mule.tooling.client.api.el.ValidationResult;

public class DefaultAgentDataWeaveExecutionResponse
implements DataWeaveExecutionResponse {
    private final boolean valid;
    private final Optional<String> result;
    private final boolean classpathError;
    private final List<DataWeaveExecutionError> errors;

    public DefaultAgentDataWeaveExecutionResponse(boolean valid, Optional<String> result, boolean classpathError, List<DataWeaveExecutionError> errors) {
        this.valid = valid;
        this.result = result;
        this.classpathError = classpathError;
        this.errors = errors;
    }

    @Override
    public Optional<String> getResult() {
        return this.result;
    }

    @Override
    public boolean isSuccess() {
        return this.valid;
    }

    @Override
    public boolean isClasspathError() {
        return this.classpathError;
    }

    @Override
    public boolean isExceptionError() {
        return false;
    }

    @Override
    public List<DataWeaveExecutionError> getErrors() {
        return this.errors;
    }

    public static DefaultAgentDataWeaveExecutionResponse from(DataWeavePreviewResponse previewResponse) {
        return new DefaultAgentDataWeaveExecutionResponse(previewResponse.isValid(), Optional.ofNullable(previewResponse.getResult()), false, previewResponse.isValid() ? Collections.emptyList() : Arrays.asList(ToolingDataWeaveExecutionError.builder().withMessage(previewResponse.getErrorMessage()).build()));
    }

    public static DefaultAgentDataWeaveExecutionResponse from(ValidationResult validationResponse) {
        List errors = validationResponse.getMessages().stream().filter(message -> Severity.ERROR.equals((Object)message.getSeverity())).collect(Collectors.toList());
        return new DefaultAgentDataWeaveExecutionResponse(errors.isEmpty(), Optional.empty(), false, errors.stream().map(DefaultAgentDataWeaveExecutionResponse::toDataWeaveExecutionError).collect(Collectors.toList()));
    }

    private static ToolingDataWeaveExecutionError toDataWeaveExecutionError(ValidationMessage validationError) {
        Location location = validationError.getLocation();
        Position startPosition = location.getStartPosition();
        Position endPosition = location.getEndPosition();
        return ToolingDataWeaveExecutionError.builder().withStartIndex(startPosition.getOffset()).withStartLine(startPosition.getLine()).withEndIndex(endPosition.getOffset()).withMessage(validationError.getMessage()).build();
    }
}

