/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.agent.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.persistence.JsonMetadataTypeWriter;
import org.mule.tooling.client.Activator;
import org.mule.tooling.client.ToolingComponentDataSenseResult;
import org.mule.tooling.client.ToolingComponentPath;
import org.mule.tooling.client.ToolingDataSenseNotification;
import org.mule.tooling.client.ToolingPropagationComponentResult;
import org.mule.tooling.client.ToolingPropagationResult;
import org.mule.tooling.client.api.ComponentDataSenseNotification;
import org.mule.tooling.client.api.ComponentDataSenseResult;
import org.mule.tooling.client.api.DataSenseToolingService;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.PropagationComponentResult;
import org.mule.tooling.client.api.PropagationResult;
import org.mule.tooling.client.api.component.location.ComponentLocation;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.datasense.ApplicationResolutionScope;
import org.mule.tooling.client.api.datasense.ComponentResolutionScope;
import org.mule.tooling.client.api.datasense.ConfigResolutionScope;
import org.mule.tooling.client.api.datasense.DataSenseComponentInfo;
import org.mule.tooling.client.api.datasense.DataSenseElementInfo;
import org.mule.tooling.client.api.datasense.DataSenseInfo;
import org.mule.tooling.client.api.datasense.DataSenseNotification;
import org.mule.tooling.client.api.datasense.DataSenseRequest;
import org.mule.tooling.client.api.datasense.DataSenseResolutionScope;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataMessage;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.mule.parameters.ParametersUtils;

public class DefaultAgentDataSenseToolingService
implements DataSenseToolingService {
    private static final boolean TOOLING_DATASENSE_LOG = Boolean.getBoolean("tooling.datasense.log");
    private static final boolean TOOLING_DATASENSE_PROPAGATION_EVENT_WRITER = Boolean.getBoolean("tooling.datasense.propagation.event.writer");
    private DataSenseService dataSenseService;

    public DefaultAgentDataSenseToolingService(DataSenseService dataSenseService) {
        this.dataSenseService = dataSenseService;
    }

    @Override
    public ComponentDataSenseResult resolveComponentDataSense(IComponentPath componentPath) {
        DataSenseRequest request = new DataSenseRequest();
        request.setDataSenseResolutionScope((DataSenseResolutionScope)new ComponentResolutionScope(Location.builderFromStringRepresentation((String)componentPath.toPath()).build(), false));
        return this.resolveComponentDataSense(request);
    }

    @Override
    public PropagationResult resolveComponentPropagation(IComponentPath componentPath) {
        DataSenseRequest request = new DataSenseRequest();
        request.setDataSenseResolutionScope((DataSenseResolutionScope)new ComponentResolutionScope(Location.builderFromStringRepresentation((String)componentPath.toPath()).build()));
        return this.resolvePropagation(request);
    }

    @Override
    public PropagationResult resolveFlowPropagation(String flowName) {
        DataSenseRequest request = new DataSenseRequest();
        request.setDataSenseResolutionScope((DataSenseResolutionScope)new ComponentResolutionScope(Location.builderFromStringRepresentation((String)flowName).build()));
        return this.resolvePropagation(request);
    }

    @Override
    public PropagationResult resolveConfigPropagation(String configId) {
        DataSenseRequest request = new DataSenseRequest();
        request.setDataSenseResolutionScope((DataSenseResolutionScope)new ConfigResolutionScope(configId));
        return this.resolvePropagation(request);
    }

    @Override
    public PropagationResult resolveApplicationPropagation() {
        DataSenseRequest request = new DataSenseRequest();
        request.setDataSenseResolutionScope((DataSenseResolutionScope)new ApplicationResolutionScope());
        return this.resolvePropagation(request);
    }

    private PropagationResult resolvePropagation(DataSenseRequest request) {
        long start = System.currentTimeMillis();
        Optional maybeDataSenseInfo = this.dataSenseService.resolveDataSense(request);
        Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task took [%s] ms", System.currentTimeMillis() - start));
        PropagationResult propagationResult = maybeDataSenseInfo.map(this::handleDataSenseInfo).orElse(ToolingPropagationResult.PropagationResultBuilder.EMPTY);
        if (Activator.getInstance().isDebugging() && TOOLING_DATASENSE_LOG) {
            MuleCorePlugin.logInfo((String)"Messages from propagation response");
            for (String message : propagationResult.getMessages()) {
                MuleCorePlugin.logInfo((String)message);
            }
        }
        return propagationResult;
    }

    private ComponentDataSenseResult resolveComponentDataSense(DataSenseRequest request) {
        long start = System.currentTimeMillis();
        Optional maybeDataSenseComponentInfo = this.dataSenseService.resolveComponentDataSense(request);
        Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task  took [%s] ms", System.currentTimeMillis() - start));
        ComponentDataSenseResult componentDataSenseResult = maybeDataSenseComponentInfo.map(this::handleDataSenseComponentInfo).orElse(ToolingComponentDataSenseResult.ComponentDataSenseResultBuilder.DEFAULT);
        if (Activator.getInstance().isDebugging() && TOOLING_DATASENSE_LOG) {
            MuleCorePlugin.logInfo((String)"Messages from component datasense response");
            for (String message : componentDataSenseResult.getMessages()) {
                MuleCorePlugin.logInfo((String)message);
            }
        }
        return componentDataSenseResult;
    }

    private ComponentDataSenseResult handleDataSenseComponentInfo(DataSenseComponentInfo dataSenseComponentInfo) {
        long start = System.currentTimeMillis();
        Optional maybeOperationModel = dataSenseComponentInfo.getOperationModel();
        Optional maybeSourceModel = dataSenseComponentInfo.getSourceModel();
        Map<String, MetadataType> metadataTypesFromOperationModel = maybeOperationModel.map(this::handleOperationModel).orElse(Collections.emptyMap());
        Map metadataTypesFromSourceModel = maybeSourceModel.map(this::handleSourceModel).orElse(Collections.emptyMap());
        ComponentDataSenseResult result = new ToolingComponentDataSenseResult.ComponentDataSenseResultBuilder().withAllowRetyping(maybeOperationModel.isPresent() || maybeSourceModel.isPresent()).withMetadataTypes(!metadataTypesFromOperationModel.isEmpty() ? metadataTypesFromOperationModel : metadataTypesFromSourceModel).withMessages(dataSenseComponentInfo.getMessages()).withNotifications(dataSenseComponentInfo.getDataSenseNotifications().stream().map(this::handleDataSenseNotification).collect(Collectors.toList())).build();
        Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task took [%s] ms", System.currentTimeMillis() - start));
        return result;
    }

    private Map<String, MetadataType> handleOperationModel(OperationModel operationModel) {
        return this.handleParameterGroupModel(operationModel.getParameterGroupModels());
    }

    private Map<String, MetadataType> handleSourceModel(SourceModel sourceModel) {
        return this.handleParameterGroupModel(sourceModel.getParameterGroupModels());
    }

    private Map<String, MetadataType> handleParameterGroupModel(List<ParameterGroupModel> parameterGroupModels) {
        HashMap<String, MetadataType> metadataTypes = new HashMap<String, MetadataType>();
        for (ParameterGroupModel parameterGroupModel : parameterGroupModels) {
            String groupName = ParametersUtils.buildGroupName((ParameterGroupModel)parameterGroupModel);
            List parameterModels = parameterGroupModel.getParameterModels();
            for (ParameterModel parameterModel : parameterModels) {
                String parameterName = parameterModel.getName();
                MetadataType metadataType = parameterModel.getType();
                metadataTypes.put(groupName + parameterName, MetadataTypeProxy.proxying(metadataType, Collections.emptyMap()));
            }
        }
        return metadataTypes;
    }

    private PropagationResult handleDataSenseInfo(DataSenseInfo dataSenseInfo) {
        HashMap<IComponentPath, PropagationComponentResult> result = new HashMap<IComponentPath, PropagationComponentResult>();
        Optional maybeDataSenseByComponentPath = dataSenseInfo.getComponentInfoByComponentPath();
        if (maybeDataSenseByComponentPath.isPresent()) {
            Map dataSenseByComponentPath = (Map)maybeDataSenseByComponentPath.get();
            for (Map.Entry entry : dataSenseByComponentPath.entrySet()) {
                result.put(ToolingComponentPath.from(((Location)entry.getKey()).toString()), this.handleDataSenseElementInfo((DataSenseElementInfo)entry.getValue()));
            }
        }
        return new ToolingPropagationResult.PropagationResultBuilder().withResult(result).withMessages(dataSenseInfo.getMessages()).withGlobalBindings(dataSenseInfo.getGlobalBindings()).withFunctionBindings(dataSenseInfo.getFunctionBindings()).withNotifications(dataSenseInfo.getDataSenseNotifications().stream().map(this::handleDataSenseNotification).collect(Collectors.toList())).build();
    }

    private ComponentDataSenseNotification handleDataSenseNotification(DataSenseNotification dataSenseNotification) {
        return new ToolingDataSenseNotification.DataSenseNotificationBuilder().withMessage(dataSenseNotification.getMessage().getMessage()).withReason(dataSenseNotification.getReason().orElse(dataSenseNotification.getMessage()).getMessage()).withComponentPath(dataSenseNotification.getComponentLocation().map(ComponentLocation::getLocation).map(ToolingComponentPath::from).orElse(null)).withNotificationType(dataSenseNotification.getNotificationType()).build();
    }

    private PropagationComponentResult handleDataSenseElementInfo(DataSenseElementInfo dataSenseElementInfo) {
        ToolingComponentPath componentPath = ToolingComponentPath.from(dataSenseElementInfo.getLocation().toString());
        Optional maybeInput = dataSenseElementInfo.getInput();
        Optional maybeOutput = dataSenseElementInfo.getOutput();
        Optional maybeIncoming = dataSenseElementInfo.getIncoming();
        Optional maybeExpected = dataSenseElementInfo.getExpected();
        Optional maybeExpectedInput = dataSenseElementInfo.getExpectedInput();
        Optional maybeResult = dataSenseElementInfo.getResult();
        MetadataEvent input = maybeInput.map(this::handleEvent).orElse(MetadataEvent.UNKNOWN_EVENT);
        MetadataEvent output = maybeOutput.map(this::handleEvent).orElse(MetadataEvent.UNKNOWN_EVENT);
        MetadataEvent incoming = maybeIncoming.map(this::handleEvent).orElse(MetadataEvent.UNKNOWN_EVENT);
        MetadataEvent expected = maybeExpected.map(this::handleEvent).orElse(MetadataEvent.UNKNOWN_EVENT);
        MetadataEvent expectedInput = maybeExpectedInput.map(this::handleEvent).orElse(MetadataEvent.UNKNOWN_EVENT);
        MetadataEvent result = maybeResult.map(this::handleEvent).orElse(MetadataEvent.UNKNOWN_EVENT);
        if (TOOLING_DATASENSE_PROPAGATION_EVENT_WRITER) {
            JsonMetadataTypeWriter writer = new JsonMetadataTypeWriter();
            writer.setPrettyPrint(true);
            MuleCorePlugin.logInfo((String)("Propagation for: " + String.valueOf(dataSenseElementInfo.getLocation())));
            this.printEvent(writer, input, "Input");
            this.printEvent(writer, output, "Output");
            this.printEvent(writer, incoming, "Incoming");
            this.printEvent(writer, expected, "Expected");
            this.printEvent(writer, result, "Result");
        }
        return new ToolingPropagationComponentResult.PropagationComponentResultBuilder().withLocation(componentPath).withInput(input).withOutput(output).withIncoming(incoming).withExpected(expected).withExpectedInput(expectedInput).withResult(result).build();
    }

    private MetadataEvent handleEvent(MetadataType event) {
        MuleEventMetadataType muleEventMetadataType = MuleEventMetadataType.builder((ObjectType)((ObjectType)event)).build();
        MessageMetadataType messageMetadataType = muleEventMetadataType.getMessageType();
        MetadataType payloadMetdataType = messageMetadataType.getPayloadType().orElse(MetadataFactory.undefined());
        MetadataType attributesMetdataType = messageMetadataType.getAttributesType().orElse(MetadataFactory.undefined());
        MetadataType errorMetadataType = muleEventMetadataType.getErrorType().orElse(MetadataFactory.undefined());
        ObjectType variablesMetadataType = muleEventMetadataType.getVariables();
        return new MetadataEvent(new MetadataMessage(payloadMetdataType, attributesMetdataType), errorMetadataType, variablesMetadataType);
    }

    private void printEvent(JsonMetadataTypeWriter writer, MetadataEvent event, String source) {
        MuleCorePlugin.logInfo((String)(source + "-Payload"));
        MuleCorePlugin.logInfo((String)writer.toString(event.getPayload()));
        MuleCorePlugin.logInfo((String)(source + "-Attributes"));
        MuleCorePlugin.logInfo((String)writer.toString(event.getAttributes()));
        MuleCorePlugin.logInfo((String)(source + "-Variables"));
        MuleCorePlugin.logInfo((String)writer.toString((MetadataType)event.getVariables()));
    }
}

