/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.ToolingApplicationServiceExecutorTemplate;
import org.mule.tooling.client.ToolingRequestContext;
import org.mule.tooling.client.ToolingValueProviderExecutionRequest;
import org.mule.tooling.client.api.ServiceResponse;
import org.mule.tooling.client.api.ValueProviderToolingService;
import org.mule.tooling.client.api.value.Value;

public class ValueProviderExecutor
extends ToolingApplicationServiceExecutorTemplate<Set<Value>> {
    private final int timeOutInMilliseconds;
    private final String componentLocation;
    private final String providerName;

    public ValueProviderExecutor(ValueProviderExecutorBuilder builder) {
        super(builder);
        assert (StringUtils.isNotEmpty((CharSequence)builder.componentLocation));
        assert (StringUtils.isNotEmpty((CharSequence)builder.providerName));
        this.timeOutInMilliseconds = builder.timeOutInMilliseconds;
        this.componentLocation = builder.componentLocation;
        this.providerName = builder.providerName;
    }

    @Override
    protected ServiceResponse<Set<Value>> doRunService(ToolingRequestContext context) {
        ValueProviderToolingService valueProviderToolingService = context.getToolingApplication().getValueProviderToolingService();
        ToolingValueProviderExecutionRequest providerRequest = ToolingValueProviderExecutionRequest.builder().withLocation(this.componentLocation).withProviderName(this.providerName).withTimeout(this.timeOutInMilliseconds).build();
        return valueProviderToolingService.retrieveValues(providerRequest);
    }

    public static class ValueProviderExecutorBuilder
    extends ToolingApplicationServiceExecutorTemplate.ToolingApplicationServiceExecutorTemplateBuilder<Set<Value>, ValueProviderExecutorBuilder> {
        int timeOutInMilliseconds;
        String componentLocation;
        String providerName;

        public ValueProviderExecutor build() {
            return new ValueProviderExecutor(this);
        }

        public ValueProviderExecutorBuilder timeOutInMilliseconds(int timeOutInMilliseconds) {
            this.timeOutInMilliseconds = timeOutInMilliseconds;
            return this.self();
        }

        public ValueProviderExecutorBuilder componentLocation(String componentLocation) {
            this.componentLocation = componentLocation;
            return this.self();
        }

        public ValueProviderExecutorBuilder providerName(String providerName) {
            this.providerName = providerName;
            return this.self();
        }

        @Override
        protected ValueProviderExecutorBuilder self() {
            return this;
        }
    }
}

