/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.ComponentDataSenseNotification;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.PropagationComponentResult;
import org.mule.tooling.client.api.PropagationResult;

public class ToolingPropagationResult
implements PropagationResult {
    private List<String> messages;
    private List<ComponentDataSenseNotification> notifications;
    private Map<IComponentPath, PropagationComponentResult> result;
    private Map<String, MetadataType> globalBindings;
    private Map<String, MetadataType> functionBindings;

    public ToolingPropagationResult(Map<IComponentPath, PropagationComponentResult> result, List<String> messages, List<ComponentDataSenseNotification> notifications, Map<String, MetadataType> globalBindings, Map<String, MetadataType> functionBindings) {
        this.result = result;
        this.messages = messages;
        this.notifications = notifications;
        this.globalBindings = globalBindings;
        this.functionBindings = functionBindings;
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }

    @Override
    public List<ComponentDataSenseNotification> getNotifcations() {
        return this.notifications;
    }

    @Override
    public Map<IComponentPath, PropagationComponentResult> getPropagationByComponentPath() {
        return this.result;
    }

    @Override
    public Map<String, MetadataType> getGlobalBindings() {
        return this.globalBindings;
    }

    @Override
    public Map<String, MetadataType> getFunctionBindings() {
        return this.functionBindings;
    }

    public static final class PropagationResultBuilder {
        public static final PropagationResult EMPTY = new PropagationResultBuilder().build();
        private List<String> messages = Collections.emptyList();
        private List<ComponentDataSenseNotification> notifications = Collections.emptyList();
        private Map<IComponentPath, PropagationComponentResult> result = new HashMap<IComponentPath, PropagationComponentResult>();
        private Map<String, MetadataType> globalBindings = Collections.emptyMap();
        private Map<String, MetadataType> functionBindings = Collections.emptyMap();

        public PropagationResult build() {
            return new ToolingPropagationResult(this.result, this.messages, this.notifications, this.globalBindings, this.functionBindings);
        }

        public PropagationResultBuilder withResult(Map<IComponentPath, PropagationComponentResult> result) {
            this.result = result;
            return this;
        }

        public PropagationResultBuilder withMessages(List<String> messages) {
            this.messages = messages;
            return this;
        }

        public PropagationResultBuilder withNotifications(List<ComponentDataSenseNotification> notifications) {
            this.notifications = notifications;
            return this;
        }

        public PropagationResultBuilder withGlobalBindings(Map<String, MetadataType> globalBindings) {
            this.globalBindings = globalBindings;
            return this;
        }

        public PropagationResultBuilder withFunctionBindings(Map<String, MetadataType> functionBindings) {
            this.functionBindings = functionBindings;
            return this;
        }
    }
}

