/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.ToolingPropagationComponentResult;
import org.mule.tooling.client.api.ComponentDataSenseNotification;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.PropagationComponentResult;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.MetadataEvent;

public class ToolingPropagationInfo
implements PropagationInfo {
    private final PropagationComponentResult propagation;
    private final List<ComponentDataSenseNotification> notifications;
    private final Map<String, MetadataType> globalBindings;
    private final Map<String, MetadataType> functionBindings;
    private final IComponentPath componentPath;

    private ToolingPropagationInfo(PropagationInfoBuilder propagationInfoBuilder) {
        this.propagation = propagationInfoBuilder.propagation;
        this.notifications = propagationInfoBuilder.notifications;
        this.globalBindings = propagationInfoBuilder.globalBindings;
        this.functionBindings = propagationInfoBuilder.functionBindings;
        this.componentPath = propagationInfoBuilder.componentPath;
    }

    @Override
    public MetadataEvent getInputMetadataType() {
        return this.propagation.getInputMetadataType();
    }

    @Override
    public MetadataEvent getOutputMetadataType() {
        return this.propagation.getOutputMetadataType();
    }

    @Override
    public MetadataEvent getIncomingMetadataType() {
        return this.propagation.getIncomingMetadataType();
    }

    @Override
    public MetadataEvent getExpectedMetadataType() {
        return this.propagation.getExpectedMetadataType();
    }

    @Override
    public MetadataEvent getExpectedInputMetadataType() {
        return this.propagation.getExpectedInputMetadataType();
    }

    @Override
    public MetadataEvent getResultMetadataType() {
        return this.propagation.getResultMetadataType();
    }

    @Override
    public List<ComponentDataSenseNotification> getNotifcations() {
        return this.notifications;
    }

    @Override
    public boolean isFlow() {
        return this.propagation.getComponentPath() != null && this.propagation.getComponentPath().isRoot();
    }

    @Override
    public boolean hasErrors() {
        return this.notifications.stream().anyMatch(pn -> pn.isError());
    }

    @Override
    public boolean hasErrorsOrWarnings() {
        return this.notifications.stream().anyMatch(pn -> pn.isError() || pn.isWarning());
    }

    @Override
    public Map<String, MetadataType> getGlobalBindings() {
        return this.globalBindings;
    }

    @Override
    public Map<String, MetadataType> getFunctionBindings() {
        return this.functionBindings;
    }

    @Override
    public IComponentPath getComponentPath() {
        return this.componentPath;
    }

    public static final class PropagationInfoBuilder {
        public static final PropagationInfo DEFAULT = new PropagationInfoBuilder().build();
        private PropagationComponentResult propagation = ToolingPropagationComponentResult.PropagationComponentResultBuilder.EMPTY;
        private List<ComponentDataSenseNotification> notifications = Collections.emptyList();
        private Map<String, MetadataType> globalBindings = Collections.emptyMap();
        private Map<String, MetadataType> functionBindings = Collections.emptyMap();
        private IComponentPath componentPath;

        public PropagationInfo build() {
            return new ToolingPropagationInfo(this);
        }

        public PropagationInfoBuilder withPropagation(PropagationComponentResult propagation) {
            this.propagation = propagation;
            return this;
        }

        public PropagationInfoBuilder withNotifications(List<ComponentDataSenseNotification> notifications) {
            this.notifications = notifications;
            return this;
        }

        public PropagationInfoBuilder withGlobalBindings(Map<String, MetadataType> globalBindings) {
            this.globalBindings = globalBindings;
            return this;
        }

        public PropagationInfoBuilder withFunctionBindings(Map<String, MetadataType> functionBindings) {
            this.functionBindings = functionBindings;
            return this;
        }

        public PropagationInfoBuilder withComponentPath(IComponentPath componentPath) {
            this.componentPath = componentPath;
            return this;
        }
    }
}

