/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.metadata.internal.utils.StringUtils;
import org.mule.tooling.client.api.metadata.MetadataKey;

public class ToolingMetadataKeyBuilder {
    private final String id;
    private String displayName;
    private Set<MetadataKey> childs = new LinkedHashSet<MetadataKey>();
    private String partName = "";

    protected ToolingMetadataKeyBuilder(String id) {
        this.id = id;
    }

    public static ToolingMetadataKeyBuilder newKey(String id) {
        return new ToolingMetadataKeyBuilder(id);
    }

    public ToolingMetadataKeyBuilder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public ToolingMetadataKeyBuilder withPartName(String partName) {
        this.setPartName(partName);
        return this;
    }

    protected void setPartName(String partName) {
        this.partName = partName;
    }

    public MetadataKey build() {
        String name = StringUtils.isNotEmpty((String)this.displayName) ? this.displayName : this.id;
        return new MetadataKey(this.id, name, this.childs, this.partName);
    }
}

