/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.menus.UIElement;
import org.mule.tooling.client.ToolingInstanceStatusNotification;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IToolingInstanceStatusChangeListener;
import org.mule.tooling.runtime.controller.MuleControllerException;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class ToolingInstanceStatusIndicator
extends AbstractHandler
implements IElementUpdater {
    private static final String RESTART_STUDIO_SERVICE = "Restart Studio services";
    private static final String ERROR_INITIALIZING_DATASENSE = "There was an error initializing some Studio services";
    private static final String TOOLING_CLIENT_PREFERENCES = "org.mule.tooling.client.ui.preferences.tooling";
    private static final String RESTARTING_DATASENSE_MESSAGE = "Restarting Studio services";
    private static final String COMMAND_PATH = "org.mule.tooling.client.toolingInstanceStatusIndicator";
    private Menu contextMenu;
    private ToolingInstanceStatusNotification toolingInstanceNotification = null;
    private ICommandService commandService;
    private boolean indicatorEnabled = false;
    private boolean initializingStudio = true;
    private final EventBusHelper eventBusHelper = new EventBusHelper();

    public ToolingInstanceStatusIndicator() {
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.commandService = (ICommandService)win.getService(ICommandService.class);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_TOOLING_INSTANCE_STATUS_CHANGE, (IEventHandler)((IToolingInstanceStatusChangeListener)() -> {
            if (this.commandService != null) {
                Display.getDefault().asyncExec(() -> {
                    this.commandService.refreshElements(COMMAND_PATH, null);
                    this.initializingStudio = false;
                });
            }
        }));
        this.createContextualMenu();
    }

    public boolean isEnabled() {
        return this.indicatorEnabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.indicatorEnabled) {
            this.contextMenu.setVisible(true);
        }
        return null;
    }

    public static void openToolingInstancePreferences(Shell shell) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)TOOLING_CLIENT_PREFERENCES, null, null);
        dialog.setBlockOnOpen(false);
        dialog.open();
    }

    public void updateElement(UIElement element, Map parameters) {
        if (!this.initializingStudio) {
            boolean isRunning = ToolingManager.getInstance().isRunning();
            if (isRunning) {
                this.indicatorEnabled = false;
                element.setIcon(MuleImages.getManaged((String)"", (String)"empty-icon.png"));
                element.setTooltip("");
            } else {
                this.indicatorEnabled = true;
                AnalyticsRecordsFactory.single((String)Events.TOOLING_INSTANCE_TURNS_OFF).track();
                element.setIcon(MuleImages.getManaged((String)"", (String)"red-indicator.png"));
                element.setTooltip("DataSense status");
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(() -> {
                    if (this.toolingInstanceNotification == null || !this.toolingInstanceNotification.isVisible()) {
                        this.toolingInstanceNotification = new ToolingInstanceStatusNotification();
                        this.toolingInstanceNotification.open();
                    }
                });
            }
        }
    }

    private void createContextualMenu() {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MenuManager menuMgr = new MenuManager();
        this.contextMenu = menuMgr.createContextMenu((Control)shell);
        menuMgr.addMenuListener(manager -> {
            manager.add((IAction)new Action(RESTART_STUDIO_SERVICE){

                public void run() {
                    AnalyticsRecordsFactory.single((String)Events.RESTART_TOOLING_INSTANCE, (String[])new String[]{"from", "statusIndicator"}).track();
                    Job job = new Job(ToolingInstanceStatusIndicator.RESTARTING_DATASENSE_MESSAGE){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                ToolingManager.getInstance().restart();
                                if ((this).ToolingInstanceStatusIndicator.this.commandService != null) {
                                    (this).ToolingInstanceStatusIndicator.this.commandService.refreshElements(ToolingInstanceStatusIndicator.COMMAND_PATH, null);
                                }
                            }
                            catch (MuleControllerException e) {
                                MuleCorePlugin.logError((String)ToolingInstanceStatusIndicator.ERROR_INITIALIZING_DATASENSE, (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
            });
            manager.add((IAction)new Action("Go to preferences"){

                public void run() {
                    ToolingInstanceStatusIndicator.openToolingInstancePreferences(shell);
                }
            });
        });
        menuMgr.setRemoveAllWhenShown(true);
    }
}

