/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.client.ToolingDataWeaveExecutionError;
import org.mule.tooling.client.api.DataWeaveExecutionError;
import org.mule.tooling.client.api.DataWeaveExecutionResponse;

public class ToolingDataWeaveExecutionResponse
implements DataWeaveExecutionResponse {
    private final boolean success;
    private final Optional<String> maybeResult;
    private final Optional<ErrorType> maybeErrorType;
    private final List<DataWeaveExecutionError> errors;

    public ToolingDataWeaveExecutionResponse(boolean success, Optional<String> maybeResult, Optional<ErrorType> maybeErrorType, List<DataWeaveExecutionError> errors) {
        this.success = success;
        this.maybeErrorType = maybeErrorType;
        this.maybeResult = maybeResult;
        this.errors = errors;
    }

    @Override
    public Optional<String> getResult() {
        return this.maybeResult;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public boolean isClasspathError() {
        return this.maybeErrorType.map(error -> ErrorType.CLASSPATH.equals(error)).orElse(false);
    }

    @Override
    public boolean isExceptionError() {
        return this.maybeErrorType.map(error -> ErrorType.EXCEPTION.equals(error)).orElse(false);
    }

    @Override
    public List<DataWeaveExecutionError> getErrors() {
        return this.errors;
    }

    public static DataWeaveExecutionResponse classpathErrorResponse() {
        return ToolingDataWeaveExecutionResponse.builder().fromClasspathError().withErrors(Arrays.asList(ToolingDataWeaveExecutionError.builder().withMessage("There are errors in the current classpath").build())).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Exception exception;
        private Optional<String> maybeResult = Optional.empty();
        private Optional<ErrorType> maybeErrorType = Optional.empty();
        private List<DataWeaveExecutionError> errors = Collections.emptyList();

        private Builder() {
        }

        public ToolingDataWeaveExecutionResponse build() {
            return new ToolingDataWeaveExecutionResponse(!this.isError(), this.maybeResult, this.maybeErrorType, this.computeErrors());
        }

        public Builder fromClasspathError() {
            this.maybeErrorType = Optional.of(ErrorType.CLASSPATH);
            return this;
        }

        private List<DataWeaveExecutionError> computeErrors() {
            return this.errors.isEmpty() && this.isError() ? Arrays.asList(ToolingDataWeaveExecutionError.builder().withMessage(this.exception.getMessage()).build()) : this.errors;
        }

        private boolean isError() {
            return this.exception != null || !this.errors.isEmpty() || this.maybeErrorType.isPresent();
        }

        public Builder withResult(String result) {
            this.maybeResult = Optional.ofNullable(result);
            return this;
        }

        public Builder withException(Exception exception) {
            this.exception = exception;
            this.maybeErrorType = Optional.of(ErrorType.EXCEPTION);
            return this;
        }

        public Builder withErrors(List<DataWeaveExecutionError> errors) {
            this.errors = errors;
            return this;
        }
    }

    private static enum ErrorType {
        CLASSPATH,
        EXCEPTION;

    }
}

