/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.DataWeaveExecutionRequest;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataTypeHelper;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;
import org.mule.tooling.utils.IContentReader;

public class ToolingDataWeaveExecutionRequest
implements DataWeaveExecutionRequest {
    private final String script;
    private final Optional<TypedValueModel> payload;
    private final Optional<TypedValueModel> attributes;
    private final Map<String, TypedValueModel> variables;
    private final Optional<MetadataEvent> eventType;
    private final Map<String, MetadataType> globalBindings;
    private final Map<String, MetadataType> functionBindings;
    private IContentReader reader;

    public ToolingDataWeaveExecutionRequest(String script, IContentReader reader, Optional<TypedValueModel> payload, Optional<TypedValueModel> attributes, Map<String, TypedValueModel> variables, Optional<MetadataEvent> eventType, Map<String, MetadataType> globalBindings, Map<String, MetadataType> functionBindings) {
        this.script = script;
        this.reader = reader;
        this.payload = payload;
        this.attributes = attributes;
        this.variables = variables;
        this.eventType = eventType;
        this.globalBindings = globalBindings;
        this.functionBindings = functionBindings;
    }

    @Override
    public boolean isValid() {
        return this.reader == null || this.script.equals(this.reader.getContent());
    }

    @Override
    public Optional<MetadataEvent> getEventType() {
        return this.eventType;
    }

    @Override
    public Map<String, MetadataType> getGlobalBindings() {
        return this.globalBindings;
    }

    @Override
    public Map<String, MetadataType> getFunctionBindings() {
        return this.functionBindings;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public EventModel getEventModel() {
        EventModel.Builder eventModelBuilder = EventModel.builder();
        MessageModel.Builder messageModel = MessageModel.builder();
        this.payload.ifPresent(arg_0 -> ((MessageModel.Builder)messageModel).withPayload(arg_0));
        this.attributes.ifPresent(arg_0 -> ((MessageModel.Builder)messageModel).withAttributes(arg_0));
        return eventModelBuilder.withMessage(messageModel.build()).withVariables(this.variables).build();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (this.functionBindings == null ? 0 : this.bindingsHashCode(this.functionBindings));
        result = 31 * result + (this.globalBindings == null ? 0 : this.bindingsHashCode(this.globalBindings));
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variables.hashCode());
        return result;
    }

    private int bindingsHashCode(Map<String, MetadataType> bindings) {
        int result = 1;
        for (Map.Entry<String, MetadataType> field : bindings.entrySet()) {
            String fieldName = field.getKey();
            result = 31 * result + (fieldName == null ? 0 : fieldName.hashCode());
            MetadataType value = field.getValue();
            result = 31 * result + (value == null ? 0 : MetadataTypeHelper.hashCode(value));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToolingDataWeaveExecutionRequest other = (ToolingDataWeaveExecutionRequest)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.eventType == null ? other.eventType != null : !this.eventType.equals(other.eventType)) {
            return false;
        }
        if (this.functionBindings == null ? other.functionBindings != null : !this.bindingsEquality(this.functionBindings, other.functionBindings)) {
            return false;
        }
        if (this.globalBindings == null ? other.globalBindings != null : !this.bindingsEquality(this.globalBindings, other.globalBindings)) {
            return false;
        }
        if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
            return false;
        }
        if (this.script == null ? other.script != null : !this.script.equals(other.script)) {
            return false;
        }
        return !(this.variables == null ? other.variables != null : !this.variables.equals(other.variables));
    }

    private boolean bindingsEquality(Map<String, MetadataType> bindings, Map<String, MetadataType> otherBindings) {
        if (bindings.size() != otherBindings.size()) {
            return false;
        }
        for (Map.Entry<String, MetadataType> binding : bindings.entrySet()) {
            MetadataType metadataType = otherBindings.get(binding.getKey());
            if (metadataType == null) {
                return false;
            }
            if (MetadataTypeHelper.hashCode(metadataType) == MetadataTypeHelper.hashCode(binding.getValue())) continue;
            return false;
        }
        return true;
    }

    public static Builder newExecutionRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String script = "";
        private Optional<TypedValueModel> payload = Optional.empty();
        private Optional<TypedValueModel> attributes = Optional.empty();
        private Map<String, TypedValueModel> variables = Collections.emptyMap();
        private Optional<MetadataEvent> eventType = Optional.empty();
        private Map<String, MetadataType> globalBindings = Collections.emptyMap();
        private Map<String, MetadataType> functionBindings = Collections.emptyMap();
        private IContentReader reader;

        private Builder() {
        }

        public ToolingDataWeaveExecutionRequest build() {
            return new ToolingDataWeaveExecutionRequest(this.script, this.reader, this.payload, this.attributes, this.variables, this.eventType, this.globalBindings, this.functionBindings);
        }

        public Builder withScript(String script) {
            this.script = script;
            return this;
        }

        public Builder withPayload(TypedValueModel payload) {
            this.payload = Optional.ofNullable(payload);
            return this;
        }

        public Builder withAttributes(TypedValueModel attributes) {
            this.attributes = Optional.ofNullable(attributes);
            return this;
        }

        public Builder withVariables(Map<String, TypedValueModel> variables) {
            this.variables = variables;
            return this;
        }

        public Builder withEventType(MetadataEvent eventType) {
            this.eventType = Optional.ofNullable(eventType);
            return this;
        }

        public Builder withGlobalBindings(Map<String, MetadataType> globalBindings) {
            this.globalBindings = globalBindings;
            return this;
        }

        public Builder withFunctionBindings(Map<String, MetadataType> functionBindings) {
            this.functionBindings = functionBindings;
            return this;
        }

        public Builder withContentReader(IContentReader reader) {
            this.reader = reader;
            return this;
        }
    }
}

