/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.Optional;
import org.mule.tooling.client.api.DataWeaveExecutionError;

public class ToolingDataWeaveExecutionError
implements DataWeaveExecutionError {
    private final Optional<Integer> startIndex;
    private final Optional<Integer> startLine;
    private final Optional<Integer> endIndex;
    private final Optional<String> message;

    public ToolingDataWeaveExecutionError(Optional<Integer> startIndex, Optional<Integer> startLine, Optional<Integer> endIndex, Optional<String> message) {
        this.startIndex = startIndex;
        this.startLine = startLine;
        this.endIndex = endIndex;
        this.message = message;
    }

    @Override
    public Optional<Integer> getStartIndex() {
        return this.startIndex;
    }

    @Override
    public Optional<Integer> getStartLine() {
        return this.startLine;
    }

    @Override
    public Optional<Integer> getEndIndex() {
        return this.endIndex;
    }

    @Override
    public Optional<String> getMessage() {
        return this.message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<Integer> startIndex = Optional.empty();
        private Optional<Integer> startLine = Optional.empty();
        private Optional<Integer> endIndex = Optional.empty();
        private Optional<String> message = Optional.empty();

        private Builder() {
        }

        public ToolingDataWeaveExecutionError build() {
            return new ToolingDataWeaveExecutionError(this.startIndex, this.startLine, this.endIndex, this.message);
        }

        public Builder withStartIndex(int startIndex) {
            this.startIndex = Optional.of(startIndex);
            return this;
        }

        public Builder withStartLine(int startLine) {
            this.startLine = Optional.of(startLine);
            return this;
        }

        public Builder withEndIndex(int endIndex) {
            this.endIndex = Optional.of(endIndex);
            return this;
        }

        public Builder withMessage(String message) {
            this.message = Optional.ofNullable(message);
            return this;
        }
    }
}

