/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.client.Activator;
import org.mule.tooling.client.api.ComponentDataSenseNotification;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.datasense.DataSenseNotificationType;

public class ToolingDataSenseNotification
implements ComponentDataSenseNotification {
    private String message;
    private String reason;
    private DataSenseNotificationType notificationType;
    private IComponentPath componentPath;
    private static final Pattern PATTERN = Pattern.compile("(?s)Failed to solve flow-ref\\. Flow '#\\[(.*)\\]' not found");
    private static final String WARNING = "WARNING";
    private static final String INFO = "INFO";

    private ToolingDataSenseNotification(DataSenseNotificationType notificationType, String message, String reason, IComponentPath componentPath) {
        this.notificationType = notificationType;
        this.message = message;
        this.reason = reason;
        this.componentPath = componentPath;
        this.handleDynamicFlowReferenceError(notificationType, message, reason);
    }

    private void handleDynamicFlowReferenceError(DataSenseNotificationType notificationType, String message, String reason) {
        Matcher matcher;
        if (notificationType.isError() && (matcher = PATTERN.matcher(this.message)).find()) {
            this.notificationType = this.getNotificationLevel(notificationType);
            this.message = this.reason = "Metadata resolution does not work when a flow-ref has a dynamic expression like: '#[" + matcher.group(1) + "]'";
        }
    }

    private DataSenseNotificationType getNotificationLevel(DataSenseNotificationType notificationType) {
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        String dynamicFlowRefNotification = preferenceStore.getString("metadataPropagation.flowReference");
        if ("Warning".equals(dynamicFlowRefNotification)) {
            return DataSenseNotificationType.warningDataSenseNotificationType((String)WARNING);
        }
        if ("Ignore".equals(dynamicFlowRefNotification) || "Info".equals(dynamicFlowRefNotification)) {
            return DataSenseNotificationType.infoDataSenseNotificationType((String)INFO);
        }
        return notificationType;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Optional<IComponentPath> getComponentPath() {
        return Optional.ofNullable(this.componentPath);
    }

    @Override
    public boolean isError() {
        return this.notificationType.isError() || this.notificationType.isFatalError();
    }

    @Override
    public boolean isWarning() {
        return this.notificationType.isWarning();
    }

    public static final class DataSenseNotificationBuilder {
        private String message;
        private String reason;
        private DataSenseNotificationType notificationType;
        private IComponentPath componentPath;

        public DataSenseNotificationBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        public DataSenseNotificationBuilder withReason(String reason) {
            this.reason = reason;
            return this;
        }

        public DataSenseNotificationBuilder withComponentPath(IComponentPath componentPath) {
            this.componentPath = componentPath;
            return this;
        }

        public DataSenseNotificationBuilder withNotificationType(DataSenseNotificationType notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        public ToolingDataSenseNotification build() {
            Objects.requireNonNull(this.message, "Message cannot be null");
            Objects.requireNonNull(this.reason, "Reason cannot be null");
            Objects.requireNonNull(this.notificationType, "Notification Type cannot be null");
            return new ToolingDataSenseNotification(this.notificationType, this.message, this.reason, this.componentPath);
        }
    }
}

